/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.teamscale.index.dashboard.widgets.CodeCityNode;
import com.teamscale.index.testgap.treemap.RelatedIssuesTreeMapNode;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import java.io.IOException;
import org.conqat.lib.commons.treemap.ITreeMapNode;

public class TreeMapNodeDeserializer
extends JsonDeserializer<ITreeMapNode<?>> {
    public ITreeMapNode<?> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        TreeNode node = p.readValueAsTree();
        return (ITreeMapNode)p.getCodec().treeToValue(node, this.determineTargetClass(node));
    }

    private Class<? extends ITreeMapNode<?>> determineTargetClass(TreeNode node) {
        if (node.get("methodName") != null) {
            return TgaMethodTreeMapNode.class;
        }
        if (node.get("buildingHeight") != null) {
            return CodeCityNode.class;
        }
        if (node.get("relatedIssueIds") != null) {
            return RelatedIssuesTreeMapNode.class;
        }
        return TreeMapNode.class;
    }

    public Class<?> handledType() {
        return ITreeMapNode.class;
    }
}

