/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.external.tests.TestMetricsManager;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestMetricsSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String IMPLEMENTATION_PARTITION = "-implementation-";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="test-execution-metrics")
    private MetricsIndex testExecutionMetricsIndex;
    @DeltaSource(value=TestImplementationIndex.class)
    private KeyDelta keyDeltaTestImplementations;
    @DeltaSource(value=TestExecutionIndex.class)
    private TestExecutionIndexDelta keyDeltaTestExecutions;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestExecutionIndex testExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestLinksIndex testLinksIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TestLinksIndex previousTestLinksIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TestImplementationPathToExecutionPathIndex previousTestImplementationPathToExecutionPathIndex;
    private TestMetricsManager testMetricsManager;
    private TestMetricsManager testExecutionMetricsManager;
    private List<PartitionAndPath> testExecutionsUpdated;
    private List<PartitionAndPath> deletedTestExecutionPartitionAndPaths;

    public void execute() throws StorageException {
        this.testMetricsManager = new TestMetricsManager(this.testExecutionMetricsIndex);
        this.testExecutionMetricsManager = new TestMetricsManager(this.testExecutionMetricsIndex);
        this.testExecutionsUpdated = this.keyDeltaTestExecutions.getAddedOrChangedPartitionsAndPaths();
        this.deletedTestExecutionPartitionAndPaths = this.keyDeltaTestExecutions.getDeletedPartitionsAndPaths();
        this.processAdditionsAndChanges();
        this.processDeletions();
    }

    private void processAdditionsAndChanges() throws StorageException {
        if (!this.keyDeltaTestImplementations.isEmpty()) {
            this.calculateAndStoreTestCountMetric();
        }
        if (!this.keyDeltaTestExecutions.isEmpty()) {
            this.calculateAndStoreTestExecutionMetrics();
        }
    }

    private void calculateAndStoreTestCountMetric() throws StorageException {
        List addedOrChangedTests = this.keyDeltaTestImplementations.getAddedOrChangedKeysAsStrings();
        List testImplementationEntries = CollectionUtils.map((Collection)addedOrChangedTests, test -> TestMetricsSynchronizer.getPartitionedPath(IMPLEMENTATION_PARTITION, test));
        this.testMetricsManager.calculateAndStoreTestCountMetric(testImplementationEntries);
    }

    private void calculateAndStoreTestExecutionMetrics() throws StorageException {
        List<TestExecutionWithPartition> addedOrChangedTestExecutions = this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(this.testExecutionsUpdated);
        Set testExecutionsPaths = CollectionUtils.mapToSet(this.testExecutionsUpdated, PartitionAndPath::getUniformPath);
        Map<String, TestLinks> testExecutionPathsToImplementationLinks = TestMetricsSynchronizer.getTestLinks(testExecutionsPaths, this.testLinksIndex);
        PairList<String, TestExecution> testImplementationPathsAndExecutions = this.buildTestImplementationMetricPaths(addedOrChangedTestExecutions, testExecutionPathsToImplementationLinks);
        PairList<String, TestExecution> testExecutionPathsAndExecutions = this.buildTestExecutionMetricPaths(addedOrChangedTestExecutions);
        this.testMetricsManager.calculateAndStoreTestExecutionMetrics(this.getSchedulingCommit(), testImplementationPathsAndExecutions);
        this.testExecutionMetricsManager.calculateAndStoreTestCountMetric((List<String>)testExecutionPathsAndExecutions.getFirstList());
        this.testExecutionMetricsManager.calculateAndStoreTestExecutionMetrics(this.getSchedulingCommit(), testExecutionPathsAndExecutions);
    }

    private static Map<String, TestLinks> getTestLinks(Set<String> testExecutionsPaths, TestLinksIndex testLinksIndex) throws StorageException {
        ArrayList<String> testExecutionsPathsList = new ArrayList<String>(testExecutionsPaths);
        List<TestLinks> testLinksForAddedOrChangedExecutions = testLinksIndex.getTestLinks(testExecutionsPathsList);
        return CollectionUtils.zipAsMap(testExecutionsPathsList, testLinksForAddedOrChangedExecutions);
    }

    private @NonNull PairList<String, TestExecution> buildTestImplementationMetricPaths(List<TestExecutionWithPartition> addedOrChangedTestExecutions, Map<String, TestLinks> testExecutionPathsToImplementationLinks) {
        PairList testImplementationPathsAndExecutions = new PairList();
        for (int i = 0; i < addedOrChangedTestExecutions.size(); ++i) {
            TestExecutionWithPartition testExecution = addedOrChangedTestExecutions.get(i);
            if (testExecution == null) {
                TestMetricsSynchronizer.logErrorForMissingTestExecution(this.testExecutionsUpdated.get(i));
                continue;
            }
            String testMetricPath = TestMetricsSynchronizer.calculateTestMetricPath(testExecutionPathsToImplementationLinks, testExecution.getPartition(), testExecution.getTestExecution().getUniformPath());
            if (testMetricPath == null) continue;
            testImplementationPathsAndExecutions.add((Object)testMetricPath, (Object)testExecution.getTestExecution());
        }
        return testImplementationPathsAndExecutions;
    }

    private @NonNull PairList<String, TestExecution> buildTestExecutionMetricPaths(List<TestExecutionWithPartition> addedOrChangedTestExecutions) {
        PairList testExecutionPathsAndExecutions = new PairList();
        for (int i = 0; i < addedOrChangedTestExecutions.size(); ++i) {
            TestExecutionWithPartition testExecution = addedOrChangedTestExecutions.get(i);
            if (testExecution == null) {
                TestMetricsSynchronizer.logErrorForMissingTestExecution(this.testExecutionsUpdated.get(i));
                continue;
            }
            String testExecutionMetricPath = TestMetricsSynchronizer.getPartitionedPath(testExecution.getPartitionAndPath());
            testExecutionPathsAndExecutions.add((Object)testExecutionMetricPath, (Object)testExecution.getTestExecution());
        }
        return testExecutionPathsAndExecutions;
    }

    private static @NonNull String getPartitionedPath(PartitionAndPath partitionAndPath) {
        return TestMetricsSynchronizer.getPartitionedPath(partitionAndPath.getPartition(), partitionAndPath.getUniformPath());
    }

    public static @NonNull String getPartitionedPath(String partition, String path) {
        String type = StringUtils.getFirstPart((String)path, (String)UniformPathUtils.SEPARATOR);
        String pathWithoutType = StringUtils.stripPrefix((String)StringUtils.stripPrefix((String)path, (String)type), (String)UniformPathUtils.SEPARATOR);
        String prefix = type + UniformPathUtils.SEPARATOR + UniformPath.escapeSegment((String)partition);
        return StringUtils.stripSuffix((String)(prefix + UniformPathUtils.SEPARATOR + pathWithoutType), (String)UniformPathUtils.SEPARATOR);
    }

    private static String calculateTestMetricPath(Map<String, TestLinks> testExecutionPathsToImplementationLinks, String partition, String uniformPath) {
        TestLinks testLinks = testExecutionPathsToImplementationLinks.get(uniformPath);
        if (testLinks == null) {
            LOGGER.debug("No test links found for '{}'! Missing links are expected in merge commits in cases where the TestExecutionMerger adds test executions that are deleted by the AnalysisReportPersister in the same commit.", (Object)uniformPath);
            return null;
        }
        String testImplementationPath = testLinks.getTestImplementation();
        if (testImplementationPath != null) {
            return TestMetricsSynchronizer.getPartitionedPath(partition, testImplementationPath + UniformPathUtils.SEPARATOR + uniformPath);
        }
        return null;
    }

    private void processDeletions() throws StorageException {
        List deletedTestImplementations = this.keyDeltaTestImplementations.getDeletedKeysAsStrings();
        Set<String> executionPathsForDeletedImplementations = this.previousTestImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPathsFlat(deletedTestImplementations);
        Set testExecutionsPaths = CollectionUtils.mapToSet(this.deletedTestExecutionPartitionAndPaths, PartitionAndPath::getUniformPath);
        Map<String, TestLinks> testLinksMap = TestMetricsSynchronizer.getTestLinks(CollectionUtils.unionSet((Collection)testExecutionsPaths, (Collection[])new Collection[]{executionPathsForDeletedImplementations}), this.previousTestLinksIndex);
        List<PartitionAndPath> testPartitionAndPathsToRemove = TestMetricsSynchronizer.getPartitionsAndPathToRemove(executionPathsForDeletedImplementations, testLinksMap);
        List<String> testImplementationWithExecutionPaths = CollectionUtils.unionSet(this.deletedTestExecutionPartitionAndPaths, (Collection[])new Collection[]{testPartitionAndPathsToRemove}).stream().map(testExecutionPartitionAndPath -> TestMetricsSynchronizer.calculateTestMetricPath(testLinksMap, testExecutionPartitionAndPath.getPartition(), testExecutionPartitionAndPath.getUniformPath())).filter(Objects::nonNull).collect(Collectors.toList());
        this.testMetricsManager.deleteMetricsForDeletedKeys(CollectionUtils.map((Collection)deletedTestImplementations, test -> TestMetricsSynchronizer.getPartitionedPath(IMPLEMENTATION_PARTITION, test)));
        this.testMetricsManager.deleteMetricsForDeletedExecutions(testImplementationWithExecutionPaths);
        List testExecutions = CollectionUtils.map(this.deletedTestExecutionPartitionAndPaths, TestMetricsSynchronizer::getPartitionedPath);
        this.testExecutionMetricsManager.deleteMetricsForDeletedKeys(testExecutions);
        this.testExecutionMetricsManager.deleteMetricsForDeletedExecutions(testExecutions);
    }

    private static @NonNull List<PartitionAndPath> getPartitionsAndPathToRemove(Set<String> executionPathsForDeletedImplementations, Map<String, TestLinks> testLinksMap) {
        ArrayList<PartitionAndPath> testPartitionAndPathsToRemove = new ArrayList<PartitionAndPath>();
        for (String executionPathsForDeletedImplementation : executionPathsForDeletedImplementations) {
            TestLinks testLinks = testLinksMap.get(executionPathsForDeletedImplementation);
            if (testLinks == null) {
                LOGGER.error("No test links found for '{}'! This should never happen! TS-30050.", (Object)executionPathsForDeletedImplementation);
                continue;
            }
            for (String partition : testLinks.getPartitions()) {
                testPartitionAndPathsToRemove.add(new PartitionAndPath(partition, executionPathsForDeletedImplementation));
            }
        }
        return testPartitionAndPathsToRemove;
    }

    private static void logErrorForMissingTestExecution(PartitionAndPath pathForMissingTestExecution) {
        LOGGER.error("Encountered added or changed test execution with null value for path and partition '{}'. This is unexpected since all added or changed test executions should exist in the TestExecutionIndex. Skipping the test execution.", (Object)pathForMissingTestExecution);
    }
}

