/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testimpact.ETestPrioritizationStrategy;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.index.testimpact.TiaTestFilterQueryParams;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class TestMinimizationRequestOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="endCommit")
    @QueryParam(value="end")
    @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"", required=true)
    private UnresolvedCommitDescriptor endCommit;
    @JsonProperty(value="partitions")
    @QueryParam(value="partitions")
    @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.")
    private Set<String> partitions;
    @JsonProperty(value="ensureProcessed")
    @QueryParam(value="ensure-processed")
    @Parameter(description="If set to true the request will fail with '412 PRECONDITION FAILED' if the exact given end commit has not been processed yet and therefore data may not be up-to-date.")
    private boolean ensureProcessed;
    @QueryParam(value="query")
    @JsonProperty(value="query")
    @Parameter(description="Do the minimization only for the tests specified by the query.", allowEmptyValue=true)
    private String query;
    @QueryParam(value="max-exec-time")
    @JsonProperty(value="maxExecTime")
    @Parameter(description="The maximum duration of the minimized test suite in milliseconds (only relevant for test suite minimization).")
    private Long maxTestSuiteRuntime;
    @QueryParam(value="clustering-regex")
    @JsonProperty(value="clusteringRegex")
    @Parameter(description="The regex that is used to determine the clustering of tests. The first capture group of the regex should match the subset of the test uniform path that represents the cluster ID. Tests with the same cluster ID are grouped and prioritized together. If left empty, each cluster contains exactly one test.")
    @DefaultValue(value="(.*)")
    private Pattern clusteringRegex;
    @JsonProperty(value="tests")
    private @Nullable Set<PartitionAndPath> tests;
    @QueryParam(value="covering-path")
    @JsonProperty(value="coveringPath")
    @Parameter(description="Consider coverage within this given uniform path only.")
    private UniformPath coveringPath;

    public TestMinimizationRequestOptions() {
    }

    public TestMinimizationRequestOptions(UnresolvedCommitDescriptor endCommit, Set<String> partitions, boolean ensureProcessed, String query, long maxTestSuiteRuntime, Pattern clusteringRegex) {
        this.endCommit = endCommit;
        this.partitions = partitions;
        this.ensureProcessed = ensureProcessed;
        this.query = query;
        this.maxTestSuiteRuntime = maxTestSuiteRuntime;
        this.clusteringRegex = clusteringRegex;
    }

    public UnresolvedCommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public Long getMaxTestSuiteRuntime() {
        return this.maxTestSuiteRuntime;
    }

    public Pattern getClusteringRegex() {
        return this.clusteringRegex;
    }

    public String getQuery() {
        return this.query;
    }

    public @Nullable Set<PartitionAndPath> getTests() {
        return this.tests;
    }

    public void setTests(@Nullable Set<PartitionAndPath> tests) {
        this.tests = tests;
    }

    public UniformPath getCoveringPath() {
        return this.coveringPath;
    }

    public TiaRequestOptions toTiaRequestOptions() {
        Set<String> partitions = this.partitions;
        if (this.tests != null) {
            partitions = this.tests.stream().map(PartitionAndPath::getPartition).collect(Collectors.toSet());
        }
        return new TiaRequestOptions(new UnresolvedCommitDescriptor(null, 0L), this.endCommit, new TiaPartitionsQueryParams(partitions, partitions.isEmpty()), ETestPrioritizationStrategy.ADDITIONAL_COVERAGE_PER_TIME, this.ensureProcessed, new TiaTestFilterQueryParams(false, false, false), this.maxTestSuiteRuntime, this.coveringPath);
    }
}

