/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitAssociationIndexBase;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="test-execution-delta", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.ABBREVIATE_STRINGS})
public class TestExecutionDeltaIndex
extends CommitAssociationIndexBase<TestExecutionDelta>
implements IProjectIndex {
    public static final String INDEX_NAME = "test-execution-delta";

    public TestExecutionDeltaIndex(IStore store) {
        super(store);
    }

    public void insertOrMerge(CommitDescriptor commit, Collection<PartitionAndPath> partitionAndPaths) throws StorageException {
        this.store.performWithLock(() -> {
            TestExecutionDelta testExecutionDelta = (TestExecutionDelta)this.getEntry(commit);
            if (testExecutionDelta == null) {
                testExecutionDelta = new TestExecutionDelta(commit);
            }
            testExecutionDelta.addAffectedTestExecutions(partitionAndPaths);
            this.setEntry(testExecutionDelta);
        }, commit.toString());
    }

    protected byte[] serializeEntry(TestExecutionDelta entry) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(entry.getCommit().getBranchName())));
        output.writeBytes(ByteArrayUtils.longToByteArray((long)entry.getCommit().getTimestamp()));
        output.writeBytes(ByteArrayUtils.intToByteArray((int)entry.getAffectedTests().size()));
        for (PartitionAndPath file : entry.getAffectedTests()) {
            output.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(file.getPartition())));
            output.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(file.getUniformPath())));
        }
        return output.toByteArray();
    }

    protected @Nullable TestExecutionDelta deserializeEntry(byte @Nullable [] bytes) throws StorageException {
        if (bytes == null) {
            return null;
        }
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        CommitDescriptor outputCommit = new CommitDescriptor(abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)0)), ByteArrayUtils.getLongFromByteArray((byte[])bytes, (int)4));
        TestExecutionDelta testExecutionDelta = new TestExecutionDelta(outputCommit);
        int offset = 12;
        int numAffectedfiles = ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)offset);
        offset += 4;
        for (int i = 0; i < numAffectedfiles; ++i) {
            String partition = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)offset));
            String uniformPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(offset + 4)));
            offset += 8;
            PartitionAndPath partitionAndPath = new PartitionAndPath(partition, uniformPath);
            testExecutionDelta.addAffectedTestExecution(partitionAndPath);
        }
        return testExecutionDelta;
    }

    @IndexValueClass
    public static class TestExecutionDelta
    extends CommitAssociatedObjectBase {
        private static final long serialVersionUID = 1L;
        private final List<PartitionAndPath> affectedTests = new ArrayList<PartitionAndPath>();

        public TestExecutionDelta(CommitDescriptor commit) {
            super(commit);
        }

        public void addAffectedTestExecution(PartitionAndPath affectedTest) {
            this.affectedTests.add(affectedTest);
        }

        public void addAffectedTestExecutions(Collection<PartitionAndPath> affectedTests) {
            this.affectedTests.addAll(affectedTests);
        }

        public UnmodifiableList<PartitionAndPath> getAffectedTests() {
            return CollectionUtils.asUnmodifiable(this.affectedTests);
        }
    }
}

