/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.user.User;
import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.user.UserRecentInteractionIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="user-recently-interacted-branches", options={EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK}, valueClasses={TimestampedInteraction.class})
public class UserRecentlyInteractedBranchesIndex
implements IProjectIndex,
IChangeTrackingIndex {
    public static final String INDEX_NAME = "user-recently-interacted-branches";
    private final UserRecentInteractionIndex delegate;

    public UserRecentlyInteractedBranchesIndex(IStore store) {
        this.delegate = new UserRecentInteractionIndex(store);
    }

    public List<TimestampedInteraction> getRecentlyInteractedBranchesWithTimestamps(User user) throws StorageException {
        ArrayList<TimestampedInteraction> result = new ArrayList<TimestampedInteraction>();
        result.addAll(this.delegate.getRecentItemsWithTimestamps(user.getUsername()));
        result.addAll(this.delegate.getRecentItemsWithTimestamps(user.getFullName()));
        for (String alias : user.getAliases()) {
            result.addAll(this.delegate.getRecentItemsWithTimestamps(alias));
        }
        return UserRecentlyInteractedBranchesIndex.removeDuplicatedIdentifierEntries(result.stream().sorted(TimestampedInteraction.TIMESTAMPED_INTERACTION_COMPARATOR.reversed()));
    }

    public List<String> getRecentlyInteractedBranches(User user) throws StorageException {
        return this.getRecentlyInteractedBranchesWithTimestamps(user).stream().map(TimestampedInteraction::identifier).toList();
    }

    public void registerInteractedBranch(String userName, String branchName, long timestamp) throws StorageException {
        this.delegate.registerItemInteraction(userName, new TimestampedInteraction(Long.valueOf(timestamp), branchName));
    }

    public void registerInteractedBranch(User user, String branchName, long timestamp) throws StorageException {
        this.registerInteractedBranch(user.getUsername(), branchName, timestamp);
    }

    private static List<TimestampedInteraction> removeDuplicatedIdentifierEntries(Stream<TimestampedInteraction> interactions) {
        ArrayList<TimestampedInteraction> duplicateFreeResult = new ArrayList<TimestampedInteraction>();
        interactions.forEach(interaction -> {
            if (duplicateFreeResult.stream().noneMatch(entry -> entry.identifier().equals(interaction.identifier()))) {
                duplicateFreeResult.add((TimestampedInteraction)interaction);
            }
        });
        return duplicateFreeResult;
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public List<String> getRecentBranches(String userName) throws StorageException {
        return this.delegate.getRecentItems(userName);
    }
}

