/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import com.fasterxml.jackson.databind.JsonNode;
import eu.cqse.check.abap.OpenSqlWriteStatement;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.abap.AbapTypeInfoExtractor;
import eu.cqse.check.framework.util.abap.FunctionCallInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.resources.Resource;

@Check(id="cqse-abap-usage-of-released-apis", languages={ELanguage.ABAP, ELanguage.ABAP_CDS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbapUsageOfReleasedApisCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEPRECATED = "deprecated";
    private static final String NOT_TO_BE_RELEASED = "notToBeReleased";
    private static final String NOT_TO_BE_RELEASED_STABLE = "notToBeReleasedStable";
    private static final Map<String, String> TYPES_READABLE_NAMES = new HashMap<String, String>();
    private final Map<String, String> showStateFindings = new HashMap<String, String>();
    @CheckOption(name="Show deprecated APIs findings", description="Show findings which are related to usage of deprecated APIs.")
    private boolean showDeprecatedFindings = true;
    @CheckOption(name="Show not-to-be-released APIs findings", description="Show findings which are related to usage of not-to-be-released APIs.")
    private boolean showNotToBeReleasedFindings = true;
    @CheckOption(name="Show not-to-be-released-stable APIs findings", description="Show findings which are related to usage of not-to-be-released-stable APIs.")
    private boolean showNotToBeReleasedStableFindings = true;
    @CheckOption(name="Object Release Info version", description="Select which object release info version is used by this check. Make sure to use a valid version name from the provided versions retrieved from the Cloudification Repository: \nobjectReleaseInfoLatest, objectReleaseInfo_2208, objectReleaseInfo_2302, objectReleaseInfo_2308, objectReleaseInfo_2402, objectReleaseInfo_2408, objectReleaseInfo_PCELatest, objectReleaseInfo_PCE2022, objectReleaseInfo_PCE2022_1, objectReleaseInfo_PCE2022_2, objectReleaseInfo_PCE2023_0, objectReleaseInfo_PCE2023_1, objectReleaseInfo_PCE2023_2")
    private String objectReleaseInfoVersion = "objectReleaseInfoLatest";
    @CheckOption(name="Included paths", description="Comma-separated list of ant patterns holding certain paths, which are designated to contain Level A objects only. The (empty) default means that every file is included")
    private Set<String> includedPaths = new HashSet<String>();
    private final HashMap<String, ObjectReleaseInfo> objectReleaseInfo = new HashMap();
    private static final TokenTypePattern TABLE_OF_PATTERN = new TokenTypePattern("<TABLE><OF><IDENTIFIER>");
    private final IncludeExcludeAntPatternSupport includeExclude = new IncludeExcludeAntPatternSupport();

    public void initialize() throws CheckException {
        if (this.showDeprecatedFindings) {
            this.showStateFindings.put(DEPRECATED, DEPRECATED);
        }
        if (this.showNotToBeReleasedFindings) {
            this.showStateFindings.put(NOT_TO_BE_RELEASED, "not-to-be-released");
        }
        if (this.showNotToBeReleasedStableFindings) {
            this.showStateFindings.put(NOT_TO_BE_RELEASED_STABLE, "not-to-be-released-stable");
        }
        if (!this.includedPaths.isEmpty()) {
            this.includedPaths.forEach(arg_0 -> ((IncludeExcludeAntPatternSupport)this.includeExclude).addIncludePattern(arg_0));
        }
        String objectReleaseInfoFile = String.format("%s/%s.json", ((Object)((Object)this)).getClass().getSimpleName(), this.objectReleaseInfoVersion);
        this.readObjectReleaseInfoJsonFile(objectReleaseInfoFile);
        AbapUsageOfReleasedApisCheck.fillTypesReadableNamesMap();
    }

    public void execute() throws CheckException {
        if (!this.includeExclude.isIncluded(this.context.getUniformPath())) {
            return;
        }
        UnmodifiableList tokens = this.context.getTokens(this.getCodeViewOption());
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        if (this.context.getLanguage() == ELanguage.ABAP) {
            this.processAmdpMethodImplementation(entities);
            this.processSQLStatements(entities);
            this.processFunctionCallStatements(entities);
            this.processVariableDeclarationStatements(entities);
            this.processTableReference((List<IToken>)tokens);
        }
        if (this.context.getLanguage() == ELanguage.ABAP_CDS) {
            this.processSQLStatements(entities);
            this.processViewDefinition(entities);
        }
    }

    private static void fillTypesReadableNamesMap() {
        TYPES_READABLE_NAMES.put("AUTH", "Authorization Field");
        TYPES_READABLE_NAMES.put("BDEF", "Behavior Definition");
        TYPES_READABLE_NAMES.put("CHAR", "Characteristic");
        TYPES_READABLE_NAMES.put("CHKC", "Check Category");
        TYPES_READABLE_NAMES.put("CHKO", "Check");
        TYPES_READABLE_NAMES.put("CHKV", "Check Variant");
        TYPES_READABLE_NAMES.put("CLAS", "Class");
        TYPES_READABLE_NAMES.put("DOMA", "Domain");
        TYPES_READABLE_NAMES.put("DRTY", "Type");
        TYPES_READABLE_NAMES.put("DSFD", "Scalar Function Definition");
        TYPES_READABLE_NAMES.put("DSFI", "Scalar Function Implementation Reference");
        TYPES_READABLE_NAMES.put("DTEL", "Data Element");
        TYPES_READABLE_NAMES.put("FDT0", "FDT/BRF+:System Application");
        TYPES_READABLE_NAMES.put("FUGR", "Function Group");
        TYPES_READABLE_NAMES.put("FUGS", "Exit Function Group");
        TYPES_READABLE_NAMES.put("G4BA", "Gateway V4 Service Group");
        TYPES_READABLE_NAMES.put("INTF", "Interface");
        TYPES_READABLE_NAMES.put("IWSV", "Gateway Service");
        TYPES_READABLE_NAMES.put("MSAG", "Message Class");
        TYPES_READABLE_NAMES.put("NONT", "SAP Object Node Type");
        TYPES_READABLE_NAMES.put("RONT", "SAP Object Type");
        TYPES_READABLE_NAMES.put("SMTG", "Email Template");
        TYPES_READABLE_NAMES.put("TABL", "Structure, Database Table");
        TYPES_READABLE_NAMES.put("TTYP", "Table Type");
        TYPES_READABLE_NAMES.put("TYPE", "Type Group");
        TYPES_READABLE_NAMES.put("XSLT", "Simple Tranasformation");
        TYPES_READABLE_NAMES.put("CDS_STOB", "CDS Entity");
        TYPES_READABLE_NAMES.put("BADI_DEF", "BAdI Definition");
        TYPES_READABLE_NAMES.put("FUNC", "Function Module");
    }

    private void readObjectReleaseInfoJsonFile(String objectReleaseInfoFile) {
        JsonNode jsonNode = null;
        Class<AbapUsageOfReleasedApisCheck> checkClass = AbapUsageOfReleasedApisCheck.class;
        String jsonContent = Resource.of(checkClass, (String)objectReleaseInfoFile).getContent();
        try {
            jsonNode = JsonUtils.deserializeFromJson((String)jsonContent);
        }
        catch (JsonSerializationException e) {
            LOGGER.error("Could not read file " + objectReleaseInfoFile + " to retrieve the released APIs for ABAP cloud development. " + checkClass.getSimpleName() + " won't work as expected", (Throwable)e);
        }
        if (jsonNode == null) {
            return;
        }
        JsonNode arrayNode = jsonNode.path("objectReleaseInfo");
        for (JsonNode elementNode : arrayNode) {
            JsonNode stateNode = elementNode.path("state");
            if (!this.showStateFindings.containsKey(stateNode.asText())) continue;
            this.processObjectReleaseInfoNode(elementNode);
        }
    }

    private void processObjectReleaseInfoNode(JsonNode elementNode) {
        ObjectReleaseInfo elementObjectReleaseInfo = ObjectReleaseInfo.createObjectReleaseInfo(elementNode);
        String objectKey = elementNode.path("objectKey").asText();
        this.objectReleaseInfo.putIfAbsent(objectKey.toLowerCase(), elementObjectReleaseInfo);
    }

    private void processAmdpMethodImplementation(List<ShallowEntity> entities) {
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.METHOD))) {
            if (!methodEntity.getSubtype().equals("method implementation")) continue;
            UnmodifiableList tokens = methodEntity.ownStartTokens();
            int usingIndex = TokenStreamUtils.findFirstTopLevel((List)tokens, (ITokenMatcher)ETokenType.USING, (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES);
            this.checkAmdpMethodImplementationObjects((List<IToken>)tokens, usingIndex);
        }
    }

    private void checkAmdpMethodImplementationObjects(List<IToken> tokens, int usingIndex) {
        if (usingIndex == -1) {
            return;
        }
        for (int i = usingIndex + 1; i < tokens.size() && tokens.get(i).getType() == ETokenType.IDENTIFIER; ++i) {
            IToken usedItemToken = tokens.get(i);
            this.checkObjectReleaseAPI(usedItemToken);
        }
    }

    private void processSQLStatements(List<ShallowEntity> entities) throws CheckException {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.STATEMENT))) {
            OpenSqlWriteStatement sqlWriteStatement;
            UnmodifiableList tokens = statement.ownStartTokens();
            if (AbapUsageOfReleasedApisCheck.isSQLReadStatement((List<IToken>)tokens)) {
                TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.FROM, ETokenType.IDENTIFIER}).forEach(arg_0 -> this.lambda$processSQLStatements$0((List)tokens, arg_0));
                continue;
            }
            if (!AbapUsageOfReleasedApisCheck.isSQLWriteAccessStatement((List<IToken>)tokens) || (sqlWriteStatement = OpenSqlWriteStatement.create((ShallowEntity)statement, (List)tokens, (ITypeResolution)this.context.getTypeResolution(this.getCodeViewOption()))) == null || sqlWriteStatement.targetsInternalTable()) continue;
            this.checkObjectReleaseAPI(sqlWriteStatement.getTableNameToken());
        }
    }

    private static boolean isSQLReadStatement(List<IToken> tokens) {
        return TokenStreamUtils.startsWithToken(tokens, (ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.WITH}) || TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.CURSOR});
    }

    private static boolean isSQLWriteAccessStatement(List<IToken> tokens) {
        return TokenStreamUtils.startsWithToken(tokens, (ETokenType[])new ETokenType[]{ETokenType.INSERT, ETokenType.MODIFY, ETokenType.UPDATE, ETokenType.DELETE});
    }

    private void processFunctionCallStatements(List<ShallowEntity> entities) {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.STATEMENT))) {
            if (!statement.getSubtype().equals("call")) continue;
            UnmodifiableList tokens = statement.ownStartTokens();
            if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION})) {
                return;
            }
            int endOfName = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)FunctionCallInfo.PARAMETER_SECTION_DELIMITERS);
            List calledFunctionTokens = tokens.subList(2, endOfName);
            if (calledFunctionTokens.size() != 1 || !EnumSet.of(ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL).contains(((IToken)calledFunctionTokens.getFirst()).getType())) continue;
            this.checkObjectReleaseAPI((IToken)calledFunctionTokens.getFirst());
        }
    }

    private void processVariableDeclarationStatements(List<ShallowEntity> entities) {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.STATEMENT))) {
            UnmodifiableList tokens;
            int typeKeywordIndex;
            if (!AbapTypeInfoExtractor.VARIABLE_DECLARATION_SUBTYPES.contains(statement.getSubtype()) || (typeKeywordIndex = TokenStreamUtils.firstTokenMatching((List)(tokens = statement.ownStartTokens()), (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE, ETokenType.LIKE}))) == -1 || typeKeywordIndex + 1 >= tokens.size()) continue;
            IToken typeNameToken = (IToken)tokens.get(typeKeywordIndex + 1);
            this.checkObjectReleaseAPI(typeNameToken);
        }
    }

    private void processTableReference(List<IToken> tokens) {
        for (List match : TABLE_OF_PATTERN.matchAll(tokens)) {
            IToken token = (IToken)CollectionUtils.getLast((List)match);
            if (token == null) continue;
            this.checkObjectReleaseAPI(token);
        }
    }

    private void processViewDefinition(List<ShallowEntity> entities) {
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.METHOD))) {
            if (!Set.of("View Definition", "View Entity Definition").contains(methodEntity.getSubtype())) continue;
            UnmodifiableList tokens = methodEntity.ownStartTokens();
            List<IToken> tableVariableTokens = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)3, (ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.FROM, ETokenType.IDENTIFIER}).stream().map(arg_0 -> AbapUsageOfReleasedApisCheck.lambda$processViewDefinition$1((List)tokens, arg_0)).toList();
            for (IToken token : tableVariableTokens) {
                this.checkObjectReleaseAPI(token);
            }
        }
    }

    private void checkObjectReleaseAPI(IToken token) {
        ObjectReleaseInfo objectRelease;
        String tokenTextUnquoted = CheckUtils.getUnquotedTextForCharacterLiteral((IToken)token);
        if (tokenTextUnquoted == null) {
            tokenTextUnquoted = token.getText();
        }
        if ((objectRelease = this.objectReleaseInfo.get(tokenTextUnquoted.toLowerCase())) != null) {
            this.buildFinding(this.getFindingMessage(objectRelease), this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private String getFindingMessage(ObjectReleaseInfo objectRelease) {
        List<ObjectReleaseInfo> successors = objectRelease.getSuccessors();
        if (!successors.isEmpty()) {
            StringBuilder successorsString = new StringBuilder();
            for (int i = 0; i < successors.size(); ++i) {
                ObjectReleaseInfo objectReleaseInfoSuccessor = successors.get(i);
                successorsString.append(TYPES_READABLE_NAMES.get(objectReleaseInfoSuccessor.getObjectType())).append(" ").append(MarkupUtils.formatAsSourceCode((String)objectReleaseInfoSuccessor.getObjectKey()));
                if (i < objectRelease.getSuccessors().size() - 2) {
                    successorsString.append(", ");
                    continue;
                }
                if (i >= objectRelease.getSuccessors().size() - 1) continue;
                successorsString.append(", or ");
            }
            return String.format("Usage of %s API. The use of %s %s is not permitted. Use %s instead.", this.showStateFindings.get(objectRelease.getState()), TYPES_READABLE_NAMES.get(objectRelease.getObjectType()), MarkupUtils.formatAsSourceCode((String)objectRelease.getObjectKey()), successorsString);
        }
        return String.format("Usage of %s API. The use of %s %s is not permitted.", this.showStateFindings.get(objectRelease.getState()), TYPES_READABLE_NAMES.get(objectRelease.getObjectType()), MarkupUtils.formatAsSourceCode((String)objectRelease.getObjectKey()));
    }

    private static /* synthetic */ IToken lambda$processViewDefinition$1(List tokens, Integer index) {
        return (IToken)tokens.get(index + 2);
    }

    private /* synthetic */ void lambda$processSQLStatements$0(List tokens, Integer index) {
        this.checkObjectReleaseAPI((IToken)tokens.get(index + 1));
    }

    private static class ObjectReleaseInfo {
        private final String tadirObject;
        private final String tadirObjName;
        private final String objectType;
        private final String objectKey;
        private final String state;
        private final List<ObjectReleaseInfo> successors;

        private ObjectReleaseInfo(String tadirObject, String tadirObjName, String objectType, String objectKey, String state, List<ObjectReleaseInfo> successors) {
            this.tadirObject = tadirObject;
            this.tadirObjName = tadirObjName;
            this.objectType = objectType;
            this.objectKey = objectKey;
            this.state = state;
            this.successors = successors;
        }

        private String getObjectType() {
            return this.objectType;
        }

        private String getObjectKey() {
            return this.objectKey;
        }

        private String getState() {
            return this.state;
        }

        private List<ObjectReleaseInfo> getSuccessors() {
            return this.successors;
        }

        private static ObjectReleaseInfo createObjectReleaseInfo(JsonNode node) {
            String tadirObject = node.path("tadirObject").asText();
            String tadirObjName = node.path("tadirObjName").asText();
            String objectType = node.path("objectType").asText();
            String objectKey = node.path("objectKey").asText().toLowerCase();
            String state = node.path("state").asText();
            JsonNode successorsArrayNode = node.path("successors");
            ArrayList<ObjectReleaseInfo> successors = new ArrayList<ObjectReleaseInfo>();
            if (!successorsArrayNode.isMissingNode()) {
                for (JsonNode successorNode : successorsArrayNode) {
                    successors.add(ObjectReleaseInfo.createObjectReleaseInfo(successorNode));
                }
            }
            return new ObjectReleaseInfo(tadirObject, tadirObjName, objectType, objectKey, state, successors);
        }
    }
}

