/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.MissingAuthorityCheckInObjectBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-missing-authority-check-in-executable-classes", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingAuthorityCheckInExecutableClassesCheck
extends MissingAuthorityCheckInObjectBase {
    @CheckOption(name="Missing AUTHORITY-CHECK in executable classes - Names of methods to be checked", description="Comma separated list of method names for which it should be checked that they start with an authority check.")
    private Set<String> relevantMethodNames = Set.of("if_apj_rt_exec_object~execute", "if_apj_dt_exec_object~execute", "if_oo_adt_classrun~main");
    @CheckOption(name="Missing AUTHORITY-CHECK in executable classes - Alternative authority check statements", description="Comma separated list (regular expressions) for alternative authority check statements, e.g. call to custom methods which encapsulate AUTHORITY-CHECK.")
    private Set<String> alternativeAuthorityChecks = Collections.emptySet();
    private static final String CHECK_NAME = "Missing AUTHORITY-CHECK in executable classes";
    private static final int ALIAS_GROUP_INDEX = 1;
    private static final int ALIASED_INTERFACE_COMPONENT_GROUP_INDEX = 2;
    private static final TokenPattern ALIAS_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.FOR}).sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.TILDE, ETokenType.IDENTIFIER}).group(2);
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws CheckException {
        List rootEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List classImplementations = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)rootEntities, EnumSet.of(EShallowEntityType.TYPE), Set.of("class implementation"));
        for (ShallowEntity classImplementation : classImplementations) {
            HashSet<String> allRelevantMethodNames = new HashSet<String>();
            allRelevantMethodNames.addAll(this.relevantMethodNames);
            allRelevantMethodNames.addAll(this.getAliasesOfRelevantMethods(rootEntities, classImplementation));
            this.checkMethodsOfClass(classImplementation, allRelevantMethodNames);
        }
    }

    private Set<String> getAliasesOfRelevantMethods(List<ShallowEntity> rootEntities, ShallowEntity classImplementationEntity) {
        ShallowEntity classDeclarationEntity = LanguageFeatureParser.ABAP.getClassDeclaration(rootEntities, classImplementationEntity);
        if (classDeclarationEntity == null) {
            LOGGER.warn("Could not find class declaration for class {}. Continuing without considering aliases for relevant methods.", (Object)classImplementationEntity.getName());
            return Collections.emptySet();
        }
        HashSet<String> relevantAliases = new HashSet<String>();
        List aliasesEntities = ShallowEntityTraversalUtils.selectEntities((Collection)classDeclarationEntity.getChildren(), entity -> entity.getType() == EShallowEntityType.META && TokenStreamUtils.startsWithToken((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.ALIASES}));
        for (ShallowEntity aliasesEntity : aliasesEntities) {
            List aliases = ALIAS_PATTERN.findAll((List)aliasesEntity.includedTokens());
            for (TokenPatternMatch alias : aliases) {
                String aliased = alias.groupString(2);
                if (this.relevantMethodNames.stream().noneMatch(aliased::equalsIgnoreCase)) continue;
                relevantAliases.add(alias.groupString(1));
            }
        }
        return relevantAliases;
    }

    private void checkMethodsOfClass(ShallowEntity classImplementationEntity, Set<String> allRelevantMethodNames) throws CheckException {
        List methods = ShallowEntityTraversalUtils.listMethodsNonRecursive(List.of(classImplementationEntity));
        for (ShallowEntity method : methods) {
            String methodName = method.getName();
            if (methodName == null) continue;
            if (allRelevantMethodNames.stream().noneMatch(methodName::equalsIgnoreCase) || this.isStartingWithAuthorityCheck(method)) continue;
            this.createFinding(method);
        }
    }

    private void createFinding(ShallowEntity method) {
        this.buildFinding("Missing authority check for method " + MarkupUtils.formatAsSourceCode((String)method.getName()), this.buildLocation().forEntityFirstLine(method)).createAndStore();
    }

    @Override
    protected Set<String> getAlternativeAuthorityChecksOption() {
        return this.alternativeAuthorityChecks;
    }
}

