/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.MissingAuthorityCheckInObjectBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-missing-authority-check-in-rfc-function-modules", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingAuthorityCheckInRfcFunctionModulesCheck
extends MissingAuthorityCheckInObjectBase {
    private static final String CHECK_NAME = "Missing AUTHORITY-CHECK in RFC enabled function modules";
    @CheckOption(name="Missing AUTHORITY-CHECK in RFC enabled function modules - Alternative authority check statements", description="Comma separated list (regular expressions) for alternative authority check statements, e.g. call to custom methods which encapsulate AUTHORITY-CHECK.")
    private Set<String> alternativeAuthorityChecks = Collections.emptySet();

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!"function".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (!AbapCheckUtils.isRfcEnabled((ICheckContext)this.context)) {
            return;
        }
        if (this.isStartingWithAuthorityCheck(entity)) {
            return;
        }
        String functionName = ((IToken)entity.ownStartTokens().get(1)).getText();
        this.buildFinding("Missing authority check at start of RFC enabled function module " + MarkupUtils.formatAsSourceCode((String)functionName), this.buildLocation().forLine(entity.getStartLine())).createAndStore();
    }

    @Override
    protected Set<String> getAlternativeAuthorityChecksOption() {
        return this.alternativeAuthorityChecks;
    }

    @Override
    protected boolean isStandardAuthorityCheck(ShallowEntity firstStatement) {
        UnmodifiableList tokens = firstStatement.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL}) && ((IToken)tokens.get(2)).getText().equalsIgnoreCase("'AUTHORITY_CHECK_RFC'")) {
            return true;
        }
        return super.isStandardAuthorityCheck(firstStatement);
    }
}

