/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-class-members-before-methods", languages={ELanguage.GOSU, ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ClassMembersBeforeMethodsCheck
extends CheckImplementationBase {
    @CheckOption(name="Exemption: constructors", description="Constructors can be in front of class members")
    private boolean exemptConstructors = false;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), Set.of(EShallowEntityType.TYPE), Set.of("class"));
        for (ShallowEntity type : types) {
            if (this.context.getLanguage() == ELanguage.CPP || this.context.getLanguage() == ELanguage.CPP_MS_CLI) {
                this.checkMemberOrderForCpp(type);
                continue;
            }
            this.checkMemberOrder(CollectionUtils.filter((Collection)type.getChildren(), child -> child.getType() == EShallowEntityType.ATTRIBUTE || child.getType() == EShallowEntityType.METHOD));
        }
    }

    private void checkMemberOrder(List<ShallowEntity> entities) throws CheckException {
        boolean methodDefinitionStarted = false;
        for (ShallowEntity entity : entities) {
            if (this.exemptConstructors && entity.getSubtype().equals("constructor")) continue;
            if (!methodDefinitionStarted && entity.getType() == EShallowEntityType.METHOD) {
                methodDefinitionStarted = this.checkForStaticInitializer(entity);
                continue;
            }
            if (!methodDefinitionStarted || entity.getType() != EShallowEntityType.ATTRIBUTE) continue;
            this.buildFinding("`" + entity.getName() + "` should be before any method declaration", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean checkForStaticInitializer(ShallowEntity entity) {
        if (this.context.getLanguage() == ELanguage.JAVA) {
            return !entity.getSubtype().equals("static initializer");
        }
        if (this.context.getLanguage() == ELanguage.CS) {
            return !entity.getSubtype().equals("static constructor");
        }
        return true;
    }

    private void checkMemberOrderForCpp(ShallowEntity classEntity) throws CheckException {
        ArrayList<ShallowEntity> membersList = new ArrayList<ShallowEntity>();
        for (ShallowEntity child : classEntity.getChildren()) {
            EShallowEntityType type = child.getType();
            if (type == EShallowEntityType.META && child.getSubtype().matches("public|protected|private")) {
                this.checkMemberOrder(membersList);
                membersList.clear();
                continue;
            }
            if (type != EShallowEntityType.ATTRIBUTE && type != EShallowEntityType.METHOD) continue;
            membersList.add(child);
        }
        this.checkMemberOrder(membersList);
    }
}

