/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.base.EntityFirstLineFindingCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-do-not-lock-this", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotLockThisCheck
extends EntityFirstLineFindingCheckBase {
    private static final ETokenType[] TARGET_SEQUENCE_1 = new ETokenType[]{ETokenType.LOCK, ETokenType.LPAREN, ETokenType.THIS, ETokenType.RPAREN};
    private static final ETokenType[] TARGET_SEQUENCE_2 = new ETokenType[]{ETokenType.SYNCHRONIZED, ETokenType.LPAREN, ETokenType.THIS, ETokenType.RPAREN};

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.containsSequence((List)statement.ownStartTokens(), (ITokenMatcher[])TARGET_SEQUENCE_1) && !TokenStreamUtils.containsSequence((List)statement.ownStartTokens(), (ITokenMatcher[])TARGET_SEQUENCE_2)) continue;
            this.processEntity(statement);
        }
    }

    protected String getFindingMessage(ShallowEntity entity) {
        switch (this.context.getLanguage()) {
            case CS: {
                return "Do not use `lock(this)`";
            }
            case JAVA: {
                return "Do not use `synchronized(this)`";
            }
        }
        CCSMAssert.fail((String)"Expected only Java or C# as input language");
        return null;
    }
}

