/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-equality-test-with-boolean-literal", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class EqualityTestWithBooleanLiteralCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        Object tokens = entity.ownStartTokens();
        if (entity.hasChildren() && tokens.size() > 0) {
            tokens = this.processIncludedChildren(entity, (List<IToken>)tokens);
        }
        List literals = TokenStreamUtils.split((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.ANDAND, ETokenType.OROR});
        ITypeResolution typeResolution = this.context.getTypeResolution(ECodeViewOption.FILTERED_PREPROCESSED);
        ScopedTypeLookup scopedTypeLookup = typeResolution.getTypeLookup(entity);
        Set variableNames = scopedTypeLookup.getAllVariables();
        for (List literalTokens : literals) {
            if (literalTokens.isEmpty() || this.context.getLanguage() == ELanguage.CS && EqualityTestWithBooleanLiteralCheck.containsNullConditionalOperatorOrIsNotBoolCSharp(literalTokens, variableNames, scopedTypeLookup) || this.context.getLanguage().isCppOrC() && PreprocessedTokenStreamUtils.isTokenMacroExpanded((IToken)((IToken)literalTokens.get(0)))) continue;
            this.createFindingsForTokenSequences(literalTokens, ETokenType.EQEQ, ETokenType.BOOLEAN_LITERAL);
            this.createFindingsForTokenSequences(literalTokens, ETokenType.NOTEQ, ETokenType.BOOLEAN_LITERAL);
            this.createFindingsForTokenSequences(literalTokens, ETokenType.BOOLEAN_LITERAL, ETokenType.EQEQ);
            this.createFindingsForTokenSequences(literalTokens, ETokenType.BOOLEAN_LITERAL, ETokenType.NOTEQ);
        }
    }

    private List<IToken> processIncludedChildren(ShallowEntity entity, List<IToken> ownStartTokens) throws CheckException {
        UnmodifiableList children = entity.getChildren();
        int ownStartTokensEndOffset = ownStartTokens.get(ownStartTokens.size() - 1).getEndOffset();
        List<ShallowEntity> relevantChildren = children.stream().filter(child -> child.getEndOffset() < ownStartTokensEndOffset).toList();
        for (ShallowEntity child2 : relevantChildren) {
            this.processEntity(child2);
        }
        List ownTokens = entity.ownTokens().stream().flatMap(iTokens -> iTokens.stream()).toList();
        return ownTokens.stream().filter(iToken -> iToken.getOffset() < ownStartTokensEndOffset).toList();
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private static boolean containsNullConditionalOperatorOrIsNotBoolCSharp(List<IToken> tokens, Set<String> variableNames, ScopedTypeLookup scopedTypeLookup) {
        if (TokenStreamUtils.containsAny(tokens, (ETokenType[])new ETokenType[]{ETokenType.QUESTION, ETokenType.SAFECALL_OPERATOR})) {
            return true;
        }
        for (String variableName : variableNames) {
            TypedVariable typedVariable;
            if (!EqualityTestWithBooleanLiteralCheck.variableIsUsedInLiteral(tokens, variableName) || (typedVariable = scopedTypeLookup.getTypeInfo(variableName)).getTypeNameWithoutGenericTypeParameter().equals("bool")) continue;
            return true;
        }
        return false;
    }

    private static boolean variableIsUsedInLiteral(List<IToken> literalTokens, String variableName) {
        return TokenStreamUtils.getTokenByTypeAndText(literalTokens, (String)variableName, (Set)CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.IDENTIFIER})) != null;
    }

    private void createFindingsForTokenSequences(List<IToken> tokens, ETokenType ... tokenTypes) {
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])tokenTypes).iterator();
        while (iterator.hasNext()) {
            int startIndex = (Integer)iterator.next();
            Optional location = this.buildLocation().forTokens(tokens.subList(startIndex, startIndex + tokenTypes.length));
            this.buildFinding("Avoid comparisons to boolean literals", location).createAndStore();
        }
    }
}

