/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.HeaderFileCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-anonymous-namespace", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AnonymousNamespaceCheck
extends HeaderFileCheckBase {
    @Override
    public void executeHeaderCheck() throws CheckException {
        List modules = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.MODULE);
        for (ShallowEntity module : modules) {
            if (!"namespace".equals(module.getSubtype()) || module.getName() == null || !module.getName().isEmpty()) continue;
            this.buildFinding("Headers should not contain anonymous namespaces", this.buildLocation().forEntity(module)).createAndStore();
        }
    }
}

