/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.binary_size;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cpp.alignment.ContainerTypeDataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.StructAlignmentInfoExtractor;
import eu.cqse.check.framework.util.cpp.alignment.TypeEntityAlignmentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-data-structure-alignment", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DataStructureAlignmentCheck
extends CheckImplementationBase {
    @CheckOption(name="Data Structure Alignment - Architecture's word size (in bits)", description="The maximum word size (in bits) that is supported by the architecture on which the application runs on (e.g., 32).\nThis option is required to accurately calculate the amount of padding a struct contains.\n")
    private int architectureWordSizeInBits = 32;
    @CheckOption(name="Data Structure Alignment - Tolerated excess padding (in bytes)", description="The amount of excess padding (in bytes) that a data structure is allowed to have.\n")
    private int allowedExcessPaddingInBytes = 4;
    private static final String FINDING_MESSAGE = "The members of this `struct` should be rearranged to remove unnecessary padding";
    private static final String TOTAL_PADDING_FINDING_PROPERTY = "Total padding (in bytes)";
    private static final String EXCESS_PADDING_FINDING_PROPERTY = "Excess padding (in bytes)";
    private static final String CHECK_NAME = "Data Structure Alignment";
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws CheckException {
        List structs = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.TYPE), Set.of("struct"));
        UnmodifiableList nonPreprocessedTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        FileDebugInformation debugInfo = new FileDebugInformation(this.context.getUniformPath());
        for (ShallowEntity struct : structs) {
            this.checkStruct(struct, (List<IToken>)nonPreprocessedTokens, debugInfo);
        }
        debugInfo.log();
    }

    private void checkStruct(ShallowEntity structEntity, List<IToken> nonPreprocessedTokens, FileDebugInformation debugInfo) {
        int minimalSize;
        TypeEntityAlignmentInfo structEntityAlignmentInfo = StructAlignmentInfoExtractor.getInstance().extract(structEntity, nonPreprocessedTokens, this.architectureWordSizeInBits / 8);
        debugInfo.attach(structEntityAlignmentInfo);
        ContainerTypeDataAlignmentInfo structAlignmentInfo = structEntityAlignmentInfo.getDefinedTypeDataAlignmentInfo();
        if (!structAlignmentInfo.hasKnownAlignment()) {
            return;
        }
        int actualSize = structAlignmentInfo.getSize();
        if (actualSize <= (minimalSize = StructAlignmentInfoExtractor.calculateMinimalSize((ContainerTypeDataAlignmentInfo)structAlignmentInfo))) {
            return;
        }
        int excessPadding = actualSize - minimalSize;
        if (excessPadding <= this.allowedExcessPaddingInBytes) {
            return;
        }
        FindingPropertyList findingPropertyList = new FindingPropertyList();
        findingPropertyList.addProperty(EXCESS_PADDING_FINDING_PROPERTY, (Object)excessPadding);
        findingPropertyList.addProperty(TOTAL_PADDING_FINDING_PROPERTY, (Object)structAlignmentInfo.getPadding());
        this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(structEntity)).addFindingProperties(findingPropertyList).createAndStore();
    }

    private static class FileDebugInformation {
        private final String fileName;
        private final List<StructDebugInformation> structsDebugInformation = new ArrayList<StructDebugInformation>();

        private FileDebugInformation(String fileName) {
            this.fileName = fileName;
        }

        private void log() {
            int numberOfStructs = this.structsDebugInformation.size();
            if (numberOfStructs == 0) {
                return;
            }
            StringBuilder debugInfo = new StringBuilder();
            this.addInfoAboutStructsWithUnknownSizes(debugInfo);
            this.addInfoAboutUnknownTypes(debugInfo);
            StringBuilder message = new StringBuilder("Debug information for structs in file " + this.fileName + ":");
            if (debugInfo.isEmpty()) {
                message.append(" Handled " + numberOfStructs + " structs without any problems");
            } else {
                message.append(" Problems discovered\n").append((CharSequence)debugInfo);
            }
            LOGGER.debug(message.toString().trim());
        }

        private void addInfoAboutStructsWithUnknownSizes(StringBuilder message) {
            List<StructDebugInformation> affectedStructs = this.structsDebugInformation.stream().filter(struct -> !struct.typesWithUnknownSize.isEmpty()).toList();
            long numberOfAffectedStructs = affectedStructs.size();
            if (numberOfAffectedStructs == 0L) {
                return;
            }
            int numberOfStructs = this.structsDebugInformation.size();
            float percentageOfAffectedStructs = (float)numberOfAffectedStructs * 100.0f / (float)numberOfStructs;
            List<ShallowEntity> entitiesWithUnknownTypeSizes = affectedStructs.stream().map(struct -> struct.structAlignmentInfo.getEntity()).toList();
            List<String> affectedMemberLocations = FileDebugInformation.getLocations(entitiesWithUnknownTypeSizes);
            this.addInfoAboutUnhandledStructs(message);
            FileDebugInformation.addBulletPoint(message, String.format("%d of %d structs (%.2f %%) contained types with unknown size (see structs in lines %s)", numberOfAffectedStructs, numberOfStructs, Float.valueOf(percentageOfAffectedStructs), affectedMemberLocations));
        }

        private void addInfoAboutUnhandledStructs(StringBuilder message) {
            int numberOfStructs = this.structsDebugInformation.size();
            List<StructDebugInformation> affectedStructs = this.structsDebugInformation.stream().filter(struct -> !struct.structAlignmentInfo.getDefinedTypeDataAlignmentInfo().hasKnownAlignment()).toList();
            List<ShallowEntity> unhandledStructEntities = affectedStructs.stream().map(struct -> struct.structAlignmentInfo.getEntity()).toList();
            List<String> unhandledStructLocations = FileDebugInformation.getLocations(unhandledStructEntities);
            long numberOfAffectedStructs = affectedStructs.size();
            float percentageOfAffectedStructs = (float)numberOfAffectedStructs * 100.0f / (float)numberOfStructs;
            FileDebugInformation.addBulletPoint(message, String.format("%d of %d structs (%.2f %%) were completely ignored (see structs in lines %s)", numberOfAffectedStructs, numberOfStructs, Float.valueOf(percentageOfAffectedStructs), unhandledStructLocations));
        }

        private void addInfoAboutUnknownTypes(StringBuilder message) {
            CounterSet allTypesDiscovered = new CounterSet();
            this.structsDebugInformation.forEach(debugInfo -> allTypesDiscovered.add(debugInfo.allTypesDiscovered));
            List typesWithUnknownSize = this.structsDebugInformation.stream().map(debugInfo -> debugInfo.typesWithUnknownSize).flatMap(Collection::stream).distinct().sorted().toList();
            long numberOfUnknownTypes = typesWithUnknownSize.size();
            if (numberOfUnknownTypes == 0L) {
                return;
            }
            long numberOfTypes = allTypesDiscovered.getKeys().size();
            float percentageOfUnknownTypes = (float)numberOfUnknownTypes * 100.0f / (float)numberOfTypes;
            FileDebugInformation.addBulletPoint(message, String.format("%d of %d types (%.2f %%) have unknown alignment: %s", numberOfUnknownTypes, numberOfTypes, Float.valueOf(percentageOfUnknownTypes), typesWithUnknownSize));
        }

        private static void addBulletPoint(StringBuilder message, String content) {
            message.append("\t- ").append(content).append("\n");
        }

        private static List<String> getLocations(List<ShallowEntity> entities) {
            return entities.stream().sorted(Comparator.comparing(ShallowEntity::getStartLine)).map(entity -> entity.getStartLine() + "-" + entity.getEndLine()).distinct().toList();
        }

        public void attach(TypeEntityAlignmentInfo struct) {
            this.structsDebugInformation.add(new StructDebugInformation(struct));
        }
    }

    private static class StructDebugInformation {
        private final TypeEntityAlignmentInfo structAlignmentInfo;
        private final CounterSet<String> allTypesDiscovered = new CounterSet();
        private final Set<String> typesWithUnknownSize = new HashSet<String>();

        private StructDebugInformation(TypeEntityAlignmentInfo structAlignmentInfo) {
            this.structAlignmentInfo = structAlignmentInfo;
            for (DataAlignmentInfo member : structAlignmentInfo.getDefinedTypeDataAlignmentInfo().getMembers()) {
                this.foundType(member);
            }
        }

        private void foundType(DataAlignmentInfo member) {
            String type = member.getType();
            this.allTypesDiscovered.inc((Object)type);
            if (!member.hasKnownAlignment()) {
                this.typesWithUnknownSize.add(type);
            }
        }
    }
}

