/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.cpp.misra.CppGlobalDeclarationsExtractorPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-multiple-extern-object-or-function-declaration", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={}, phases={CppGlobalDeclarationsExtractorPhase.class})
public class MultipleExternObjectOrFunctionDeclarationCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        Function<String, List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration>> uniformPathToLiterals = MultipleExternObjectOrFunctionDeclarationCheck.limitToExternalDeclarations(this.context.accessPhaseResult(CppGlobalDeclarationsExtractorPhase.class));
        Function<String, List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration>> literalToSiblings = MultipleExternObjectOrFunctionDeclarationCheck.limitToExternalDeclarations(this.context.accessPhaseInvertedResult(CppGlobalDeclarationsExtractorPhase.class));
        String uniformPath = this.context.getUniformPath();
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration> externDeclarationsInFile = uniformPathToLiterals.apply(uniformPath);
        for (CppGlobalDeclarationsExtractorPhase.GlobalDeclaration externDeclaration : externDeclarationsInFile) {
            List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration> sameExternDeclarations;
            List otherSiblingLocations;
            int tokenIndex = TokenStreamUtils.indexOfByOffset((List)tokens, (int)externDeclaration.getStartOffset());
            if (tokenIndex == -1 || (otherSiblingLocations = CollectionUtils.filterAndMap(sameExternDeclarations = literalToSiblings.apply(externDeclaration.getValue()), literal -> this.isSameExternalDeclaration(externDeclaration, (CppGlobalDeclarationsExtractorPhase.GlobalDeclaration)literal), globalDeclaration -> globalDeclaration.getAdditionalInformation().getLocation())).isEmpty()) continue;
            String message = "Multiple declarations of " + externDeclaration.getValue();
            TextRegionLocation mainLocation = externDeclaration.getAdditionalInformation().getLocation();
            this.context.buildFinding(message, (ElementLocation)mainLocation).addSiblingLocations(otherSiblingLocations).createAndStore();
        }
    }

    private static Function<String, List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration>> limitToExternalDeclarations(Function<String, List<CppGlobalDeclarationsExtractorPhase.GlobalDeclaration>> function) {
        return function.andThen(list -> CollectionUtils.filter((Collection)list, CppGlobalDeclarationsExtractorPhase.GlobalDeclaration::isExternal));
    }

    private boolean isSameExternalDeclaration(CppGlobalDeclarationsExtractorPhase.GlobalDeclaration declarationFirst, CppGlobalDeclarationsExtractorPhase.GlobalDeclaration declarationSecond) {
        if (Objects.equals(declarationFirst.getUniformPath(), declarationSecond.getUniformPath())) {
            return false;
        }
        CppGlobalDeclarationsExtractorPhase.DeclarationSignature firstEntity = declarationFirst.getAdditionalInformation().getSignature();
        CppGlobalDeclarationsExtractorPhase.DeclarationSignature secondEntity = declarationSecond.getAdditionalInformation().getSignature();
        if (firstEntity.entityType() == EShallowEntityType.METHOD && secondEntity.entityType() == EShallowEntityType.METHOD) {
            List<String> firstMethodParamTypes = firstEntity.paramTypes();
            List<String> secondMethodParamTypes = secondEntity.paramTypes();
            String firstMethodReturnType = firstEntity.returnType();
            String secondMethodReturnType = secondEntity.returnType();
            return firstMethodParamTypes.equals(secondMethodParamTypes) && Objects.equals(firstMethodReturnType, secondMethodReturnType);
        }
        return true;
    }
}

