/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.cpp.misra.preprocessor.PreprocessorDirectiveUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Check(id="cqse-preprocessor-directive-end", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PreprocessorDirectiveEndCheck
extends CheckImplementationBase {
    private static final EnumSet<EDirectiveType> OPENING_BRANCHING = EnumSet.of(EDirectiveType.OPENING, EDirectiveType.BRANCHING);

    public void execute() throws CheckException {
        this.checkDirectives(this.getDirectiveTokens());
    }

    private List<IToken> getDirectiveTokens() throws CheckException {
        return this.context.getTokens(ECodeViewOption.FILTERED).stream().filter(token -> token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE).collect(Collectors.toList());
    }

    private void checkDirectives(List<IToken> directives) throws CheckException {
        PairList directivesAndTypes = (PairList)directives.stream().map(token -> Pair.createPair((Object)token, (Object)((Object)EDirectiveType.getDirectiveType(PreprocessorDirectiveUtils.getDirectiveCommand(token).orElse(null))))).collect(PairList.toPairList());
        Stack<Pair<IToken, EDirectiveType>> stack = new Stack<Pair<IToken, EDirectiveType>>();
        for (Pair directiveAndType : directivesAndTypes) {
            this.handleDanglingDirectives((Pair<IToken, EDirectiveType>)directiveAndType, stack);
        }
        this.handleUnclosedDirectives(stack);
    }

    private void handleDanglingDirectives(Pair<IToken, EDirectiveType> directiveAndType, Stack<Pair<IToken, EDirectiveType>> stack) throws CheckException {
        switch (((EDirectiveType)((Object)directiveAndType.getSecond())).ordinal()) {
            case 2: {
                while (!stack.isEmpty() && stack.peek().getSecond() != EDirectiveType.OPENING) {
                    stack.pop();
                }
                if (stack.empty()) {
                    this.createFinding((IToken)directiveAndType.getFirst());
                    break;
                }
                stack.pop();
                break;
            }
            case 1: {
                if (stack.isEmpty() || !OPENING_BRANCHING.contains(stack.peek().getSecond())) {
                    stack.push((Pair<IToken, EDirectiveType>)Pair.createPair(null, (Object)((Object)EDirectiveType.OPENING)));
                    this.createFinding((IToken)directiveAndType.getFirst());
                }
            }
            case 0: {
                stack.push(directiveAndType);
                break;
            }
        }
    }

    private void handleUnclosedDirectives(Stack<Pair<IToken, EDirectiveType>> stack) throws CheckException {
        while (!stack.isEmpty()) {
            Pair<IToken, EDirectiveType> entry = stack.pop();
            if (!stack.isEmpty() && stack.peek().getFirst() == null) {
                stack.pop();
                continue;
            }
            this.createFinding((IToken)entry.getFirst());
        }
    }

    private void createFinding(IToken token) throws CheckException {
        EDirectiveType type = EDirectiveType.getDirectiveType(PreprocessorDirectiveUtils.getDirectiveCommand(token).get());
        switch (type.ordinal()) {
            case 0: {
                this.buildFinding("There is no `#endif` found for `" + token.getText() + "`", this.buildLocation().forToken(token)).createAndStore();
                break;
            }
            case 1: 
            case 2: {
                this.buildFinding("There is no `#if`, `#ifdef` or `#ifndef` found for `" + token.getText() + "`", this.buildLocation().forToken(token)).createAndStore();
                break;
            }
        }
    }

    private static enum EDirectiveType {
        OPENING("#if", "#ifdef", "#ifndef"),
        BRANCHING("#else", "#elif"),
        CLOSING("#endif"),
        OTHER(new String[0]);

        private final Set<String> keywords;

        private EDirectiveType(String ... keywords) {
            this.keywords = CollectionUtils.asHashSet((Object[])keywords);
        }

        private static EDirectiveType getDirectiveType(String keyword) {
            for (EDirectiveType type : EDirectiveType.values()) {
                if (!type.keywords.contains(keyword)) continue;
                return type;
            }
            return OTHER;
        }
    }
}

