/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.cpp.misra.preprocessor.PreprocessorDirectiveUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-preprocessor-directive-line-start", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PreprocessorDirectiveLineStartCheck
extends TokenFilterCheckBase {
    static final String DESCRIPTION = "Every line starting with '#' has to be a valid preprocessing directive.";
    private static final Set<String> VALID_PREPROCESSOR_DIRECTIVES = CollectionUtils.asHashSet((Object[])new String[]{"#include", "#define", "#undef", "#if", "#ifdef", "#ifndef", "#endif", "#error", "#else", "#elif", "#pragma", "#import", "#warning"});
    private static final EnumSet<ETokenType> PREPROCESSOR_TOKEN_TYPES = EnumSet.of(ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.PREPROCESSOR_INCLUDE, ETokenType.PRAGMA_DIRECTIVE);
    private int line = -1;

    @Override
    protected List<IToken> getTokens() throws CheckException {
        return TokenStreamUtils.removeDoxygenTokens(super.getTokens());
    }

    @Override
    protected String getFindingMessage(IToken token) {
        return DESCRIPTION;
    }

    @Override
    protected boolean isValidToken(IToken token) {
        if (token.getLineNumber() <= this.line) {
            return true;
        }
        ++this.line;
        return !PREPROCESSOR_TOKEN_TYPES.contains(token.getType()) || VALID_PREPROCESSOR_DIRECTIVES.contains(PreprocessorDirectiveUtils.getDirectiveCommand(token).orElse(null));
    }
}

