/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-for-loop-should-be-while-loop", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.GROOVY, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.OBJECTIVE_C, ELanguage.PHP, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ForLoopShouldBeWhileLoopCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"for".equals(statement.getSubtype()) || this.shouldBeIgnored(statement)) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List<List<IToken>> headComponents = this.getForHeadComponents(entity);
        if (headComponents == null) {
            return;
        }
        if (headComponents.size() == 3 && headComponents.get(0).isEmpty() && headComponents.get(2).isEmpty() && !headComponents.get(1).isEmpty()) {
            this.buildFinding("`for` loop without initializer and update statements should be simplified to `while` loop", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    protected boolean shouldBeIgnored(ShallowEntity entity) {
        return TokenStreamUtils.count((List)entity.ownStartTokens(), (ETokenType)ETokenType.SEMICOLON) != 2 || ForLoopShouldBeWhileLoopCheck.forIsFromMacro(entity);
    }

    private static boolean forIsFromMacro(ShallowEntity forEntity) {
        return PreprocessedTokenStreamUtils.firstTokenOfTypeIsFromMacro((List)forEntity.ownStartTokens(), EnumSet.of(ETokenType.FOR));
    }

    private List<List<IToken>> getForHeadComponents(ShallowEntity entity) throws CheckException {
        List forHeadTokens = PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage()) ? this.getUnpreprocessedHeadTokens((List<IToken>)entity.ownStartTokens()) : TokenStreamUtils.tokensBetweenWithNesting((List)entity.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (CollectionUtils.isNullOrEmpty((Collection)forHeadTokens)) {
            return null;
        }
        return TokenStreamUtils.split((List)forHeadTokens, (ETokenType[])new ETokenType[]{ETokenType.SEMICOLON});
    }

    private List<IToken> getUnpreprocessedHeadTokens(List<IToken> forTokens) throws CheckException {
        int forHeadStartIndex = TokenStreamUtils.firstTokenMatching(forTokens, (ITokenMatcher)ETokenType.LPAREN);
        int forHeadEndIndex = TokenStreamUtils.lastTokenMatching(forTokens, (ITokenMatcher)ETokenType.RPAREN);
        if (forHeadStartIndex < 0 || forHeadEndIndex < 0 || forHeadEndIndex - forHeadStartIndex <= 0) {
            LOGGER.warn("No valid start/end index found for `for` loop head parenthesis: start={}, end={} : {}", (Object)forHeadStartIndex, (Object)forHeadEndIndex, (Object)TokenStreamTextUtils.concatTokenTexts(forTokens, (String)" "));
            return null;
        }
        UnmodifiableList rawTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        int rawStartIndex = TokenStreamUtils.indexOfByOffset((List)rawTokens, (int)forTokens.get(forHeadStartIndex).getOffset());
        int rawEndIndex = TokenStreamUtils.indexOfByOffset((List)rawTokens, (int)forTokens.get(forHeadEndIndex).getOffset());
        if (rawStartIndex < 0 || rawEndIndex < 0 || rawEndIndex - rawStartIndex <= 0) {
            return null;
        }
        return rawTokens.subList(rawStartIndex + 1, rawEndIndex);
    }
}

