/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.clike.CLikeAvoidUnusedPrivateMethodsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionPredicates;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.cs.CsCheckUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-cs-avoid-unused-private-methods", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CsAvoidUnusedPrivateMethodsCheck
extends CLikeAvoidUnusedPrivateMethodsCheckBase {
    public static final String NAME = "Avoid unused private methods in C#";

    public CsAvoidUnusedPrivateMethodsCheck() {
        super((CLikeLanguageFeatureParserBase)LanguageFeatureParser.CS);
        this.languageFeatureParser = LanguageFeatureParser.CS;
    }

    @Override
    protected List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> getMethodCalls() throws CheckException {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity methodCallEntity : this.getUnfilteredStatementAndAttributeEntities()) {
            methodCalls.addAll(this.extractMethodCallsFromEntity(methodCallEntity, (List<IToken>)methodCallEntity.includedTokens()));
            methodCalls.addAll(this.extractMethodCallsFromInterpolatedCallTokens(methodCallEntity));
            methodCalls.addAll(CsAvoidUnusedPrivateMethodsCheck.extractMethodCallsFromMethodReferences(methodCallEntity));
        }
        methodCalls.addAll(this.extractMethodCallsFromConstructorEntities());
        methodCalls.addAll(this.extractSuperClassConstructorCalls());
        methodCalls.addAll(this.extractMethodReferencesFromNunitTestCaseSourceAnnotations());
        methodCalls.addAll(this.extractIdentifiersFromDynamicDataAttributes());
        return methodCalls;
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractSuperClassConstructorCalls() throws CheckException {
        List entities = ShallowEntityTraversalUtils.listEntitiesOfType(this.getAbstractSyntaxTree(), (EShallowEntityType)EShallowEntityType.TYPE);
        return entities.stream().flatMap(CsAvoidUnusedPrivateMethodsCheck::createCallsForTypeEntity).toList();
    }

    private static Stream<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> createCallsForTypeEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        int start = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.COLON);
        return TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)start, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).stream().map(arg_0 -> CsAvoidUnusedPrivateMethodsCheck.lambda$createCallsForTypeEntity$0((List)tokens, arg_0)).map(n -> CsAvoidUnusedPrivateMethodsCheck.createMethodCall(n, entity));
    }

    @Override
    protected List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> getMethodDefinitionsToCheck() throws CheckException {
        List methodDefinitions = this.select("//TYPE[not(modifiers('partial'))]/METHOD[not(subtype('constructor')) and modifiers('private')][not(modifiers('protected'))]");
        return this.extractMethodDefinitions(CollectionUtils.filter((Collection)methodDefinitions, m -> !CsCheckUtils.isMainMethod((ShallowEntity)m)));
    }

    private static List<List<IToken>> getInterpolatedCallTokens(ShallowEntity entity) {
        return CsCheckUtils.tokenizeInterpolatedCalls((List)CsCheckUtils.extractInterpolatedCalls((List)entity.includedTokens()));
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodCallsFromInterpolatedCallTokens(ShallowEntity entity) {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (List<IToken> tokens : CsAvoidUnusedPrivateMethodsCheck.getInterpolatedCallTokens(entity)) {
            methodCalls.addAll(CsAvoidUnusedPrivateMethodsCheck.extractMethodCallsFromTokens(entity, tokens));
            tokens = tokens.subList(1, tokens.size() - 1);
            methodCalls.addAll(super.extractMethodCallsFromEntity(entity, tokens));
        }
        return methodCalls;
    }

    private static List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodCallsFromMethodReferences(ShallowEntity entity) {
        return CsAvoidUnusedPrivateMethodsCheck.extractMethodCallsFromTokens(entity, (List<IToken>)entity.includedTokens());
    }

    private static List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodCallsFromTokens(ShallowEntity entity, List<IToken> tokens) {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        SetMap methodReferencesWithArities = CsCheckUtils.retrieveMethodReferences(tokens);
        String className = CsAvoidUnusedPrivateMethodsCheck.getClassName(entity, tokens, 0);
        for (String methodName : methodReferencesWithArities.getKeys()) {
            int numberOfParameters = (Integer)((Set)methodReferencesWithArities.getCollection((Object)methodName)).iterator().next();
            methodCalls.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodName, className, numberOfParameters, false, entity));
        }
        return methodCalls;
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodCallsFromConstructorEntities() throws CheckException {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        List entities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(this.getAbstractSyntaxTree(), Collections.singleton(EShallowEntityType.METHOD), Collections.singleton("constructor"));
        for (ShallowEntity constructorEntity : entities) {
            List parameterTokens = LanguageFeatureParser.CS.getConstructorCallParameterTokens(constructorEntity);
            methodCalls.addAll(this.extractMethodCallsFromEntity(constructorEntity, parameterTokens));
            CsAvoidUnusedPrivateMethodsCheck.extractMethodCallsFromFunctionReferencesInThisOrBaseCallsInConstructorEntities(constructorEntity, methodCalls);
        }
        return methodCalls;
    }

    private static void extractMethodCallsFromFunctionReferencesInThisOrBaseCallsInConstructorEntities(ShallowEntity constructorEntity, List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls) {
        ShallowEntity parentEntity = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)constructorEntity, (Predicate)EntitySelectionPredicates.type()).orElse(null);
        String className = "";
        if (parentEntity != null) {
            className = parentEntity.getName();
        }
        UnmodifiableList ownStartTokens = constructorEntity.ownStartTokens();
        for (int i = 0; i < ownStartTokens.size(); ++i) {
            if (((IToken)ownStartTokens.get(i)).getType() != ETokenType.IDENTIFIER || i >= ownStartTokens.size() - 1 || ((IToken)ownStartTokens.get(i + 1)).getType() != ETokenType.RPAREN && ((IToken)ownStartTokens.get(i + 1)).getType() != ETokenType.COMMA) continue;
            methodCalls.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(((IToken)ownStartTokens.get(i)).getText(), className, 0, false, constructorEntity));
        }
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodReferencesFromNunitTestCaseSourceAnnotations() throws CheckException {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> result = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity annotation : this.getMetaAttributeAnnotations()) {
            UnmodifiableList annotationTokens = annotation.ownStartTokens();
            int index = TokenStreamTextUtils.findFirst((List)annotationTokens, (String)"TestCaseSource");
            if (index == -1 || index + 1 >= annotationTokens.size()) continue;
            List tokens = TokenStreamUtils.tokensBetweenWithNesting((List)annotationTokens, (int)(index + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            for (IToken token : tokens) {
                if (token.getType() == ETokenType.STRING_LITERAL) {
                    String text = token.getText().replaceAll("\"", "");
                    result.add(CsAvoidUnusedPrivateMethodsCheck.createMethodCall(text, annotation));
                    continue;
                }
                if (token.getType() != ETokenType.IDENTIFIER) continue;
                result.add(CsAvoidUnusedPrivateMethodsCheck.createMethodCall(token.getText(), annotation));
            }
        }
        return result;
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractIdentifiersFromDynamicDataAttributes() throws CheckException {
        List<ShallowEntity> attributes = this.getMetaAttributeAnnotations().stream().filter(attribute -> attribute.ownStartTokens().size() > 4 && ((IToken)attribute.ownStartTokens().get(1)).getText().equals("DynamicData")).toList();
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> result = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity attribute2 : attributes) {
            UnmodifiableList tokens = attribute2.ownStartTokens();
            for (int i = 2; i < tokens.size(); ++i) {
                IToken token = (IToken)tokens.get(i);
                if (token.getType() != ETokenType.IDENTIFIER || token.getText().equals("nameof") && i + 1 < tokens.size() && ((IToken)tokens.get(i + 1)).getType() == ETokenType.LPAREN) continue;
                result.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(token.getText(), "", -1, false, attribute2));
            }
        }
        return result;
    }

    private List<ShallowEntity> getMetaAttributeAnnotations() throws CheckException {
        return ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(this.getAbstractSyntaxTree(), Collections.singleton(EShallowEntityType.META), Collections.singleton("attribute annotation"));
    }

    private static CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription createMethodCall(String methodName, ShallowEntity entity) {
        return new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodName, "", -1, false, entity);
    }

    private static /* synthetic */ String lambda$createCallsForTypeEntity$0(List tokens, Integer i) {
        return ((IToken)tokens.get(i)).getText();
    }
}

