/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-same-package-import", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SamePackageImportCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        HashSet<String> packageEntityNames = new HashSet<String>();
        ArrayList<ShallowEntity> importEntities = new ArrayList<ShallowEntity>();
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() != EShallowEntityType.META) continue;
            if ("package".equals(topLevelEntity.getSubtype())) {
                packageEntityNames.add(topLevelEntity.getName());
            }
            if (!"import".equals(topLevelEntity.getSubtype())) continue;
            importEntities.add(topLevelEntity);
        }
        for (ShallowEntity importEntity : importEntities) {
            this.processPackageEntity(importEntity, packageEntityNames);
        }
    }

    private void processPackageEntity(ShallowEntity importEntity, Set<String> packageEntityNames) {
        String importEntityPackage = StringUtils.removeLastPart((String)importEntity.getName(), (char)'.');
        if (packageEntityNames.contains(importEntityPackage)) {
            this.buildFinding("Unnecessary import of class from own package: `" + importEntityPackage + "`", this.buildLocation().forEntity(importEntity)).createAndStore();
        }
    }
}

