/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.javascript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-unnecessary-arrow-function-braces", languages={ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnnecessaryArrowFunctionBracesCheck
extends CheckImplementationBase {
    private static final ETokenType[] ARROW_FUNCTION_PARENTHESIS = new ETokenType[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.DOUBLE_ARROW};

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List foundSequenceIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)tokens, (int)0, (int)(tokens.size() - 1), (ETokenType[])ARROW_FUNCTION_PARENTHESIS);
        Iterator iterator = foundSequenceIndices.iterator();
        while (iterator.hasNext()) {
            int indexOfFindingSequence = (Integer)iterator.next();
            this.buildFinding("Unnecessary braces at begin of arrow function", this.buildLocation().forToken((IToken)tokens.get(indexOfFindingSequence))).createAndStore();
        }
    }
}

