/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.sql_like.SqlLikeCustomCheckUtils;
import java.util.List;

@Check(id="cqse-prefer-join-over-get-function", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PreferJoinOverGetFunctionCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<ShallowEntity> selectedEntities = SqlLikeCustomCheckUtils.selectStatementsOrCursorsPerformingSelect(this.context.getRootEntity(this.getCodeViewOption()));
        for (ShallowEntity entity : selectedEntities) {
            this.processEntity(entity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List<IToken> tokens = SqlLikeCustomCheckUtils.extractSelect(entity);
        int whereIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.WHERE);
        if (whereIndex == -1) {
            return;
        }
        int endWhereIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)whereIndex, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GROUP, ETokenType.HAVING, ETokenType.ORDER, ETokenType.UNION}));
        if (endWhereIndex == -1) {
            endWhereIndex = tokens.size();
        }
        for (IToken token : tokens.subList(whereIndex + 1, endWhereIndex)) {
            if (!token.getText().toLowerCase().startsWith("get_")) continue;
            this.buildFinding("`Get_` function in `WHERE` clause", this.buildLocation().forToken(token)).createAndStore();
        }
    }
}

