/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0211", languages={ELanguage.SIMULINK})
public class SimulinkBlockInOutPortNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the inport or outport block name so that it does not start with a digit or an underscore, end with an underscore, have more than one consecutive underscore or consist of either a restricted keyword or MATLAB function name.");
    @CheckOption(name="Disallow non-alphanumeric characters in inport and outport names", description="If set, inport and outport names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in inport and outport names", description="If set, inport and outport names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in inport and outport names", description="If set, inport and outport names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in inport and outport names", description="If set, inport and outport names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in inport and outport names", description="If set, inport and outport names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow reserved MATLAB keywords in inport and outport names", description="If set, inport and outport names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow MATLAB function names in inport and outport names", description="If set, inport and outport names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = false;
    @CheckOption(name="Whitelisted inport and outport names", description="List of all inport and outport names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String blockType = block.getType();
            if (!SimulinkUtils.isInport((SimulinkBlock)block) && !SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            String portName = SimulinkBusUtils.isBusElementPort((SimulinkBlock)block) ? block.getParameter("InterfaceData.PortName") : block.getName();
            Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName);
            List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(portName, typesToCheck, this.whitelistedNames);
            for (ESimulinkNameCheckType failedCheck : failedChecks) {
                this.createFindingFromNameCheckType(block, blockType, failedCheck);
            }
        }
    }

    private void createFindingFromNameCheckType(SimulinkBlock block, String blockType, ESimulinkNameCheckType failedCheckType) {
        String prettyBlockName = MarkupUtils.formatAsSourceCode((String)block.getNamePretty());
        String findingMessageFormat = "{0} block {1} {2}";
        switch (failedCheckType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.buildFinding(MessageFormat.format(findingMessageFormat, blockType, prettyBlockName, "shall contain only letters, digits and underscores"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.buildFinding(MessageFormat.format(findingMessageFormat, blockType, prettyBlockName, "shall not start with a digit"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding(MessageFormat.format(findingMessageFormat, blockType, prettyBlockName, "shall not have consecutive underscores"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding(MessageFormat.format(findingMessageFormat, blockType, prettyBlockName, "shall not start with an underscore"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding(MessageFormat.format(findingMessageFormat, blockType, prettyBlockName, "shall not end with an underscore"), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding("Block " + prettyBlockName + " shall not be merely a MATLAB function name", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding("Block " + prettyBlockName + " shall not be merely a reserved MATLAB keyword", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                break;
            }
        }
    }
}

