/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0142", languages={ELanguage.SIMULINK})
public class SimulinkBlockNamesPositionCheck
extends CheckImplementationBase {
    private static final String RECOMMENDED_ACTION_MESSAGE = "Adjust the position of the block name so that it appears {0} the block.";
    @CheckOption(name="Ignore hidden block names", description="If set, hidden block names are not checked.")
    private boolean ignoreHiddenBlockNames = true;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (this.ignoreHiddenBlockNames && !block.hasVisibleName()) continue;
            EOrientation orientation = block.obtainBlockLayoutData().getOrientation();
            if (EOrientation.DOWN == orientation || EOrientation.UP == orientation) {
                this.checkNameLocation(block, "right", "right of");
                continue;
            }
            this.checkNameLocation(block, "bottom", "below");
        }
    }

    private void checkNameLocation(SimulinkBlock block, String allowedNameLocation, String messageText) {
        String nameLocation = block.getParameter("NameLocation");
        if (null != nameLocation && !allowedNameLocation.equals(nameLocation)) {
            String orientation = block.obtainBlockLayoutData().getOrientation().toString().toLowerCase();
            String message = MessageFormat.format("Block name must be shown {0} the block since the orientation of the block is `{1}`", messageText, orientation);
            FindingPropertyList recommendedAction = FindingPropertyList.singleton((String)"Recommended Action", (String)MessageFormat.format(RECOMMENDED_ACTION_MESSAGE, messageText));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(recommendedAction).createAndStore();
        }
    }
}

