/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0110", languages={ELanguage.SIMULINK})
public class SimulinkBlockOrientationCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_ROTATE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Flip or rotate these blocks to the default orientation.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            EOrientation blockOrientation;
            if (block.isOfType("Delay") || block.isOfType("UnitDelay") || (blockOrientation = block.obtainBlockLayoutData().getOrientation()) == EOrientation.RIGHT) continue;
            this.context.buildFinding("Block is reversed or rotated", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_ROTATE).createAndStore();
        }
    }
}

