/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.hd_0001", languages={ELanguage.SIMULINK})
public class SimulinkProhibitedSinkBlocksCheck
extends CheckImplementationBase {
    @CheckOption(name="prohibited sink block types", description="The block types that shall not be used. The given types apply to the 'type' property of simulink blocks or to the 'SourceType' property (for blocks of type Reference). See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private List<String> prohibitedBlockTypes = Arrays.asList("Stop", "ToFile", "ToWorkspace");
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove sink blocks from the model.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String typeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
            if (typeOrSourceType == null || !this.prohibitedBlockTypes.contains(typeOrSourceType)) continue;
            this.buildFinding("Don't use prohibited sink block type " + typeOrSourceType, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

