/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0081_port", languages={ELanguage.SIMULINK})
public class SimulinkUnconnectedPortCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect the port to a source or destination block, if known. Otherwise connect the port to a ground or terminator block.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (model.isLibraryModel() && block.getParent() == model || SimulinkUtils.isImmediateChildOfVariantSubsystem((SimulinkBlock)block) || SimulinkUnconnectedPortCheck.isDirectlyNestedInStateflowChartBlock(block) || !SimulinkUnconnectedPortCheck.hasUnconnectedPorts(block)) continue;
            this.buildFinding("Block has unconnected port", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean isDirectlyNestedInStateflowChartBlock(SimulinkBlock block) {
        return block.getParent() != null && block.getParent().isStateflowChartBlock();
    }

    private static boolean hasUnconnectedPorts(SimulinkBlock block) {
        return SimulinkUnconnectedPortCheck.isAnyUnconnected((Collection<? extends SimulinkPortBase>)block.getInPorts()) || SimulinkUnconnectedPortCheck.isAnyUnconnected((Collection<? extends SimulinkPortBase>)block.getOutPorts());
    }

    private static boolean isAnyUnconnected(Collection<? extends SimulinkPortBase> ports) {
        return !ports.stream().allMatch(SimulinkPortBase::isConnected);
    }
}

