/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0131", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfRelationalOperatorBlocksCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Constant block is used as the first input of a Relational Operator block";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Move Constant block to the second input port of the Relational Operator block.");

    public void execute() {
        Optional maybeModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (maybeModel.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)maybeModel.get()), (boolean)false, (boolean)false)) {
            if (!block.isOfType("RelationalOperator")) continue;
            this.checkRelationalOperator(block);
        }
    }

    private void checkRelationalOperator(SimulinkBlock block) {
        List inLines = block.getInLines();
        if (inLines.size() < 2) {
            return;
        }
        if (SimulinkUsageOfRelationalOperatorBlocksCheck.hasConstantSrcBlock((SimulinkLine)inLines.get(0)) && !SimulinkUsageOfRelationalOperatorBlocksCheck.hasConstantSrcBlock((SimulinkLine)inLines.get(1))) {
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean hasConstantSrcBlock(SimulinkLine line) {
        SimulinkOutPort srcPort = line.getSrcPort();
        return srcPort != null && srcPort.getBlock().isOfType("Constant");
    }
}

