/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0039", languages={ELanguage.SIMULINK})
public class SimulinkStateflowBlockInFunctionBlockCheck
extends CheckImplementationBase {
    private static final String RECOMMENDED_ACTION = "Modify the nesting of the Stateflow chart so that it is not contained in a Simulink function block inside a Stateflow chart";

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            this.checkStateflowBlock(stateflowBlock);
        }
    }

    private void checkStateflowBlock(StateflowBlock stateflowBlock) {
        Optional<SimulinkBlock> nearestFunctionBlockAncestorOptional = SimulinkStateflowBlockInFunctionBlockCheck.getNearestFunctionBlockAncestor((SimulinkBlock)stateflowBlock);
        if (nearestFunctionBlockAncestorOptional.isEmpty()) {
            return;
        }
        SimulinkBlock nearestFunctionBlockAncestor = nearestFunctionBlockAncestorOptional.get();
        Optional nearestStateflowBlockAncestorOptional = StateflowUtils.getNearestStateflowBlockAncestor((SimulinkBlock)nearestFunctionBlockAncestor);
        if (nearestStateflowBlockAncestorOptional.isPresent()) {
            FindingPropertyList properties = new FindingPropertyList();
            properties.addProperty("Recommended Action", (Object)RECOMMENDED_ACTION);
            this.context.buildFinding("Stateflow chart " + MarkupUtils.formatAsSourceCode((String)stateflowBlock.getNamePretty()) + " is nested in a function block in a Stateflow chart", (ElementLocation)this.context.buildLocation().forSimulinkBlock((SimulinkBlock)stateflowBlock)).addFindingProperties(properties).createAndStore();
        }
    }

    private static Optional<SimulinkBlock> getNearestFunctionBlockAncestor(SimulinkBlock block) {
        for (SimulinkBlock currentBlock = block.getParent(); currentBlock != null; currentBlock = currentBlock.getParent()) {
            if (!SimulinkStateflowBlockInFunctionBlockCheck.isSimulinkFunctionBlock(currentBlock)) continue;
            return Optional.of(currentBlock);
        }
        return Optional.empty();
    }

    private static boolean isSimulinkFunctionBlock(SimulinkBlock block) {
        if (!block.isOfType("SubSystem")) {
            return false;
        }
        Optional<SimulinkBlock> triggerBlock = block.getSubBlocks().stream().filter(child -> child.isOfType("TriggerPort")).findFirst();
        return triggerBlock.isPresent() && "function-call".equals(triggerBlock.get().getParameter("TriggerType"));
    }
}

