/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0739", languages={ELanguage.SIMULINK})
public class SimulinkStateflowTextInsideStatesCheck
extends CheckImplementationBase {
    private static final double X_FONT_OFFSET_PER_CHAR = 0.5;
    private static final double Y_FONT_OFFSET_PER_LINE = 0.5;
    private static final double X_SPACE_OFFSET_PER_SPACE_CHAR = 1.0;
    private static final String FINDING_MESSAGE = "Stateflow state has text exceeding its boundary";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Ensure the text inside the Stateflow state is not described outside the boundary of the state.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        UnmodifiableCollection allChartsInModel = StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false);
        List allNodesInModel = allChartsInModel.stream().map(chart -> StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)).flatMap(Collection::stream).collect(Collectors.toList());
        List allStates = CollectionUtils.filterAndMap(allNodesInModel, node -> node instanceof StateflowState, node -> (StateflowState)node);
        List<StateflowTransition> allTransitions = allChartsInModel.stream().map(chart -> StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)).flatMap(Collection::stream).collect(Collectors.toList());
        this.checkStates(allStates);
        this.checkTransitions(allTransitions);
    }

    private void checkStates(Collection<StateflowState> allStates) {
        List statesToCheck = CollectionUtils.filter(allStates, state -> !StringUtils.isEmpty((String)state.getLabel()));
        for (StateflowState state2 : statesToCheck) {
            String[] stateLabelLines = state2.getLabel().split("\\\\n");
            String longestLineInLabel = SimulinkStateflowTextInsideStatesCheck.getLongestLineFromText(state2.getLabel(), state2.obtainLabelData());
            this.checkStateLabelBoundaries(state2, longestLineInLabel, stateLabelLines.length, state2.obtainLabelData());
        }
    }

    private void checkTransitions(Collection<StateflowTransition> allTransitions) {
        List transitionsToCheck = CollectionUtils.filter(allTransitions, transition -> !StringUtils.isEmpty((String)transition.getLabel()) && transition.getSrc() != null && transition.getDst() != null && ((IStateflowNodeContainer)transition.getSrc().getParent()).getStateflowId().equals(((IStateflowNodeContainer)transition.getDst().getParent()).getStateflowId()) && transition.getDst().getParent() instanceof StateflowState);
        HashSet<StateflowState> violatedStates = new HashSet<StateflowState>();
        for (StateflowTransition transition2 : transitionsToCheck) {
            StateflowState dstStateParent = (StateflowState)transition2.getDst().getParent();
            if (violatedStates.contains(dstStateParent)) continue;
            String[] transitionLabelLines = transition2.getLabel().split("\\\\n");
            String longestLineInLabel = SimulinkStateflowTextInsideStatesCheck.getLongestLineFromText(transition2.getLabel(), (LabelLayoutData)transition2.obtainLabelData());
            boolean labelExceedsState = this.checkTransitionLabelBoundaries(dstStateParent, longestLineInLabel, transitionLabelLines.length, (LabelLayoutData)transition2.obtainLabelData());
            if (!labelExceedsState) continue;
            violatedStates.add(dstStateParent);
        }
    }

    private boolean checkTransitionLabelBoundaries(StateflowState stateToCheck, String longestTransitionLabelLine, int totalTransitionLabelLines, LabelLayoutData transitionLabelLayoutData) {
        boolean textInsideStateBounds = SimulinkStateflowTextInsideStatesCheck.isLabelWithinStateBounds(stateToCheck, longestTransitionLabelLine, totalTransitionLabelLines, transitionLabelLayoutData);
        if (textInsideStateBounds) {
            return false;
        }
        this.context.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)stateToCheck)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        return true;
    }

    private void checkStateLabelBoundaries(StateflowState stateToCheck, String longestStateLabelLine, int totalStateLabelLines, LabelLayoutData stateLabelLayoutData) {
        boolean textInsideStateBounds = SimulinkStateflowTextInsideStatesCheck.isLabelWithinStateBounds(stateToCheck, longestStateLabelLine, totalStateLabelLines, stateLabelLayoutData);
        if (textInsideStateBounds) {
            return;
        }
        this.context.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)stateToCheck)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        if (stateToCheck.getParent() instanceof StateflowState) {
            StateflowState parentState = (StateflowState)stateToCheck.getParent();
            this.checkStateLabelBoundaries(parentState, longestStateLabelLine, totalStateLabelLines, stateLabelLayoutData);
        }
    }

    private static boolean isLabelWithinStateBounds(StateflowState stateToCheck, String longestLabelLine, int totalLabelLines, LabelLayoutData labelLayoutData) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Font stateFont = labelLayoutData.getFont().getAwtFont();
        int labelWidth = (int)stateFont.getStringBounds(longestLabelLine, fontRenderContext).getWidth();
        int lineHeight = (int)stateFont.getStringBounds(longestLabelLine, fontRenderContext).getHeight();
        Rectangle stateRectangle = stateToCheck.obtainLayoutData().getPosition();
        Point stateLabelPosition = labelLayoutData.getPosition();
        int spacesCount = (int)longestLabelLine.chars().filter(ch -> ch == 32).count();
        int widthOffset = (int)(0.5 * (double)(longestLabelLine.length() - spacesCount) + 1.0 * (double)spacesCount);
        int labelWidthWithSlack = labelWidth - widthOffset;
        int labelHeightWithSlack = (int)((double)lineHeight - 0.5) * totalLabelLines;
        return stateRectangle.contains(stateLabelPosition.x, stateLabelPosition.y, labelWidthWithSlack, labelHeightWithSlack);
    }

    private static String getLongestLineFromText(String text, LabelLayoutData labelLayoutData) {
        String[] stateText = text.split("\\\\n");
        String longestLine = "";
        int maxLineWidth = 0;
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Font stateFont = labelLayoutData.getFont().getAwtFont();
        for (String line : stateText) {
            int lineWidth = (int)stateFont.getStringBounds(line, fontRenderContext).getWidth();
            if (lineWidth <= maxLineWidth) continue;
            longestLine = line;
            maxLineWidth = lineWidth;
        }
        return longestLine;
    }
}

