/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0753", languages={ELanguage.SIMULINK})
public class SimulinkStateflowTransitionAndConditionActionsCheck
extends CheckImplementationBase {
    @CheckOption(name="Allow transition actions", description="Refers to MAAB rule JC_0753. If not checked, no transition actions are allowed in Stateflow charts (sub ID a1). If checked either only transition actions oronly conditions actions are allowed within a Stateflow chart (sub ID a2).")
    private boolean allowTransitionActions = false;
    private static final String FINDING_MESSAGE_A1 = "Use of a transition action in a Stateflow transition";
    private static final String FINDING_MESSAGE_A2 = "Mixed usage of transition and condition actions in a Stateflow chart";
    private static final FindingPropertyList RECOMMENDED_ACTION_A1 = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove all transition actions from the Stateflow chart.");
    private static final String RECOMMENDED_ACTION_A2 = "Do not mix condition and transition actions within a Stateflow chart. Use either only condition actions or only transition actions.";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        model.getStateflowMachine().getCharts(false).forEach(this::checkChart);
    }

    private void checkChart(StateflowChart chart) {
        Set transitions = StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false);
        if (!this.allowTransitionActions) {
            this.checkSubIdA1(transitions);
        } else {
            this.checkSubIdA2(transitions, chart);
        }
    }

    private void checkSubIdA1(Set<StateflowTransition> transitions) {
        for (StateflowTransition transition : transitions) {
            if (!SimulinkStateflowTransitionAndConditionActionsCheck.hasTransitionAction(transition)) continue;
            this.context.buildFinding(FINDING_MESSAGE_A1, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION_A1).createAndStore();
        }
    }

    private void checkSubIdA2(Set<StateflowTransition> transitions, StateflowChart chart) {
        List<String> filteredTransitions = SimulinkStateflowTransitionAndConditionActionsCheck.filterTransitions(transitions);
        if (filteredTransitions.isEmpty()) {
            return;
        }
        FindingPropertyList findingPropertiesA2 = new FindingPropertyList();
        findingPropertiesA2.addProperty("Recommended Action", (Object)RECOMMENDED_ACTION_A2);
        findingPropertiesA2.addProperty("Transitions that violate the rule", (Object)String.join((CharSequence)", \n\n", filteredTransitions));
        this.context.buildFinding(FINDING_MESSAGE_A2, (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)chart.getStateflowBlock())).addFindingProperties(findingPropertiesA2).createAndStore();
    }

    private static List<String> filterTransitions(Set<StateflowTransition> transitions) {
        List<String> filteredTransitions = transitions.stream().filter(SimulinkStateflowTransitionAndConditionActionsCheck::hasConditionAction).map(StateflowTransition::getLabel).distinct().collect(Collectors.toList());
        if (filteredTransitions.isEmpty()) {
            return Collections.emptyList();
        }
        List transitionActionTransitions = transitions.stream().filter(SimulinkStateflowTransitionAndConditionActionsCheck::hasTransitionAction).map(StateflowTransition::getLabel).distinct().collect(Collectors.toList());
        if (!filteredTransitions.addAll(transitionActionTransitions)) {
            return Collections.emptyList();
        }
        return filteredTransitions;
    }

    private static boolean hasTransitionAction(StateflowTransition transition) {
        String label = transition.getLabel();
        if (label == null) {
            return false;
        }
        return transition.getLabel().split("/\\{").length > 1;
    }

    private static boolean hasConditionAction(StateflowTransition transition) {
        String label = transition.getLabel();
        if (label == null) {
            return false;
        }
        return label.startsWith("{") || transition.getLabel().split("](\\\\n)?\\{").length > 1;
    }
}

