/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisl_0061", languages={ELanguage.SIMULINK})
public class SimulinkStateflowUniqueIdentifierCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use an identifier which is unique across all scopes of a Stateflow chart.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            StateflowChart chart = stateflowBlock.getChart();
            this.checkStateflowChart(chart);
        }
    }

    private void checkStateflowChart(StateflowChart chart) {
        ListMap identifierSetWithNode = new ListMap();
        for (StateflowNodeBase node2 : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            for (StateflowData dataDeclaredInNode : node2.getData()) {
                String name = dataDeclaredInNode.getName();
                if (name == null) continue;
                identifierSetWithNode.add((Object)name, (Object)node2);
            }
        }
        for (String variableName : identifierSetWithNode.getKeys()) {
            List declaringNodes = (List)identifierSetWithNode.getCollection((Object)variableName);
            if (declaringNodes.size() == 1) continue;
            declaringNodes.forEach(node -> this.createFindingFor(variableName, (StateflowNodeBase)node));
        }
    }

    private void createFindingFor(String variableName, StateflowNodeBase node) {
        this.context.buildFinding("Identifier " + variableName + " was declared in multiple scopes in chart", (ElementLocation)this.context.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }
}

