/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0773", languages={ELanguage.SIMULINK})
public class SimulinkUnconditionalTransitionOfFlowChartsCheck
extends CheckImplementationBase {
    private static final String NO_UNCONDITIONAL_TRANSITION_FINDINGS_MESSAGE = "Stateflow junction shall provide an outgoing unconditional transition";
    private static final String EXECUTION_ORDER_FINDINGS_MESSAGE = "Outgoing unconditional transitions from Stateflow junctions shall be executed last";
    private static final FindingPropertyList NO_UNCONDITIONAL_TRANSITION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider adding an unconditional transition to the junction.");
    private static final FindingPropertyList EXECUTION_ORDER_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider setting the order of execution of the unconditional transition to the highest value (i.e., lowest priority).");
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        StateflowMachine stateflowMachine = model.getStateflowMachine();
        for (StateflowChart chart : stateflowMachine.getCharts(false)) {
            this.checkUnconditionalTransitionsOfChart(chart);
        }
    }

    private void checkUnconditionalTransitionsOfChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (node instanceof StateflowJunction && !SimulinkUnconditionalTransitionOfFlowChartsCheck.containsUnconditionalTransitionOrEmpty(node)) {
                this.buildFinding(NO_UNCONDITIONAL_TRANSITION_FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(NO_UNCONDITIONAL_TRANSITION_RECOMMENDED_ACTION).createAndStore();
                continue;
            }
            Optional<Long> optOrderOfLastExecutedTransition = SimulinkUnconditionalTransitionOfFlowChartsCheck.getOrderOfLastExecutedTransition(node);
            if (optOrderOfLastExecutedTransition.isEmpty()) continue;
            this.checkExecutionOrderOfUnconditionalTransitions(node, optOrderOfLastExecutedTransition.get());
        }
    }

    private void checkExecutionOrderOfUnconditionalTransitions(StateflowNodeBase node, long orderOfLastExecutedTransition) {
        String nodeQualifiedName = node.buildQualifiedName();
        for (StateflowTransition transition : node.getOutTransitions()) {
            Optional<Long> optExecutionOrder = SimulinkUnconditionalTransitionOfFlowChartsCheck.getTransitionExecutionOrder(transition, nodeQualifiedName);
            if (optExecutionOrder.isEmpty()) continue;
            long executionOrder = optExecutionOrder.get();
            if (!StateflowCheckUtils.isUnconditionalTransition((StateflowTransition)transition) || orderOfLastExecutedTransition == executionOrder) continue;
            this.buildFinding(EXECUTION_ORDER_FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(EXECUTION_ORDER_RECOMMENDED_ACTION).createAndStore();
            break;
        }
    }

    private static Optional<Long> getOrderOfLastExecutedTransition(StateflowNodeBase node) {
        UnmodifiableSet outTransitions = node.getOutTransitions();
        if (outTransitions.size() < 2) {
            return Optional.empty();
        }
        String nodeQualifiedName = node.buildQualifiedName();
        long maxOrder = 0L;
        for (StateflowTransition transition : outTransitions) {
            long order;
            Optional<Long> optionalExecutionOrder = SimulinkUnconditionalTransitionOfFlowChartsCheck.getTransitionExecutionOrder(transition, nodeQualifiedName);
            if (optionalExecutionOrder.isEmpty() || (order = optionalExecutionOrder.get().longValue()) <= maxOrder) continue;
            maxOrder = order;
        }
        return Optional.of(maxOrder);
    }

    private static Optional<Long> getTransitionExecutionOrder(StateflowTransition transition, String nodeQualifiedPath) {
        String executionOrder = transition.getParameter("executionOrder");
        try {
            return Optional.of(Long.parseLong(executionOrder));
        }
        catch (NumberFormatException e) {
            LOGGER.warn(MessageFormat.format("Not a valid execution order: {0} for transition ({1}) in node ({2})", executionOrder, transition.buildQualifiedName(), nodeQualifiedPath));
            return Optional.empty();
        }
    }

    private static boolean containsUnconditionalTransitionOrEmpty(StateflowNodeBase node) {
        UnmodifiableSet outTransitions = node.getOutTransitions();
        return outTransitions.stream().anyMatch(StateflowCheckUtils::isUnconditionalTransition) || outTransitions.isEmpty();
    }
}

