/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-missing-language-definition", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingLanguageDefinitionCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (!TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.LANGUAGE})) {
            this.buildFinding("Missing LANGUAGE specification", this.buildLocation().betweenTokens((IToken)tokens.get(0), (IToken)tokens.get(tokens.size() - 1))).createAndStore();
        }
    }
}

