/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia.parsable.rule;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithException;

public class TypedSetRule<V>
extends ParsableRule {
    public final Set<V> values;

    public TypedSetRule(Set<String> itemTypes, Set<V> values) {
        super(itemTypes);
        this.values = values;
    }

    public static class Parser<V>
    extends ParsableRule.RuleParser {
        private FunctionWithException<String, V, CheckException> valueParser;

        public Parser<V> withValueParser(FunctionWithException<String, V, CheckException> valueParser) {
            this.valueParser = valueParser;
            return this;
        }

        @Override
        public TypedSetRule<V> parse(String rule) throws CheckException {
            Pair<String, String> assignment = Parser.parseAssignment(rule);
            Set<String> stringSet = Parser.parseSet((String)assignment.getSecond());
            if (stringSet.isEmpty()) {
                throw new CheckException("Unable to parse set \"%s\", has to contain at least one element".formatted(assignment.getSecond()));
            }
            HashSet<Object> values = new HashSet<Object>();
            for (String string : stringSet) {
                values.add(this.valueParser.apply((Object)string));
            }
            return new TypedSetRule(Parser.parseSet((String)assignment.getFirst()), values);
        }
    }
}

