/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.rollback;

import java.util.Map;
import java.util.UUID;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.RollbackableHistorizingStore;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class StoreRollbackUtils {
    public static boolean supportsRollback(SchemaEntry schemaEntry) throws StorageException {
        if (schemaEntry.usesOption(EStorageOption.NO_ROLLBACK) || schemaEntry.usesOption(EStorageOption.VIRTUAL) || schemaEntry.isHistorized()) {
            return true;
        }
        return IRollbackableIndex.class.isAssignableFrom(schemaEntry.createIndexClass());
    }

    public static void performRollback(SchemaAwareStorageSystem storageSystem, Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        IndexSchema schema = storageSystem.getSchema();
        for (String name : schema.getEntryNames()) {
            SchemaEntry schemaEntry = schema.getEntry(name);
            if (schemaEntry.usesOption(EStorageOption.NO_ROLLBACK) || schemaEntry.usesOption(EStorageOption.VIRTUAL)) continue;
            StoreRollbackUtils.performRollback(storageSystem, name, schema, timestampByBranch, rollbackId);
        }
    }

    public static void performRollback(SchemaAwareStorageSystem storageSystem, String storeName, IndexSchema schema, Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        Class<? extends IStorageIndex> indexClass = schemaEntry.createIndexClass();
        if (schemaEntry.usesOption(EStorageOption.HISTORIZED)) {
            IStore store = schema.openStoreChecked(indexClass, storeName, storageSystem, true, null, null, null);
            new RollbackableHistorizingStore(store).performRollback(timestampByBranch, rollbackId);
            return;
        }
        if (schemaEntry.usesOption(EStorageOption.BRANCHED)) {
            IStore store = schema.openStoreChecked(indexClass, storeName, storageSystem, true, null, null, null);
            IBranchingLayer.create(store, schemaEntry).performRollback(timestampByBranch);
            return;
        }
        if (IRollbackableIndex.class.isAssignableFrom(indexClass)) {
            IRollbackableIndex index = (IRollbackableIndex)((Object)storageSystem.openIndex(indexClass, storeName));
            index.performRollback(timestampByBranch, rollbackId);
            return;
        }
        throw new StorageException("Don't know how to perform rollback for store " + storeName);
    }

    private StoreRollbackUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

