/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.Deflater;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.format.Mat5Subsystem;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.format.McosReference;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sinks;
import us.hebi.matlab.mat.util.Preconditions;
import us.hebi.matlab.mat.util.Tasks;

public final class Mat5Writer {
    protected final Sink sink;
    protected int deflateLevel = 1;
    private long headerStart = -1L;
    private long subsysLocation = 0L;
    private ExecutorService executorService = null;
    private BufferAllocator bufferAllocator = Mat5.getDefaultBufferAllocator();
    private final List<Future<FlushAction>> flushActions = new ArrayList<Future<FlushAction>>(16);
    private Deflater deflater = null;

    public Mat5Writer setDeflateLevel(int deflateLevel) {
        this.deflateLevel = deflateLevel;
        return this;
    }

    public Mat5Writer enableConcurrentCompression(ExecutorService executorService) {
        return this.enableConcurrentCompression(executorService, Mat5.getDefaultBufferAllocator());
    }

    public Mat5Writer enableConcurrentCompression(ExecutorService executorService, BufferAllocator bufferAllocator) {
        this.executorService = Preconditions.checkNotNull(executorService, "empty executor service");
        this.bufferAllocator = Preconditions.checkNotNull(bufferAllocator, "empty buffer allocator");
        this.deflater = null;
        return this;
    }

    public Mat5Writer writeMat(MatFile matFile) throws IOException {
        if (matFile instanceof Mat5File) {
            return this.writeMat((Mat5File)matFile);
        }
        throw new IllegalArgumentException("MatFile does not support the MAT5 format");
    }

    private Mat5Writer writeMat(Mat5File matFile) throws IOException {
        if (!matFile.hasReducedHeader()) {
            this.headerStart = this.sink.position();
        }
        matFile.writeFileHeader(this.sink);
        for (MatFile.Entry entry : matFile.getEntries()) {
            this.writeEntry(entry);
        }
        if (matFile.getSubsystem() != null) {
            this.writeEntry(matFile.getSubsystem());
        }
        this.flush();
        return this;
    }

    public Mat5Writer writeEntry(MatFile.Entry entry) throws IOException {
        return this.writeArray(entry.getName(), entry.isGlobal(), entry.getValue());
    }

    public Mat5Writer writeArray(String name, Array value) throws IOException {
        return this.writeArray(name, false, value);
    }

    public Mat5Writer writeArray(final String name, final boolean isGlobal, final Array array) throws IOException {
        if (!(name != null && !name.isEmpty() || array instanceof McosReference || array instanceof Mat5Subsystem)) {
            throw new IllegalArgumentException("Root Array can't have an empty name");
        }
        final boolean isSubsystem = array instanceof Mat5Subsystem;
        if (this.deflateLevel == 0) {
            if (this.flushActions.isEmpty()) {
                if (isSubsystem) {
                    this.nextEntryIsSubsystem();
                }
                Mat5WriteUtil.writeArray(name, isGlobal, array, this.sink);
            } else {
                FlushAction action = new FlushAction(){

                    @Override
                    public void run() throws IOException {
                        if (isSubsystem) {
                            Mat5Writer.this.nextEntryIsSubsystem();
                        }
                        Mat5WriteUtil.writeArray(name, isGlobal, array, Mat5Writer.this.sink);
                    }
                };
                this.flushActions.add(Tasks.wrapAsFuture(action));
            }
        } else {
            if (this.executorService == null) {
                Preconditions.checkState(this.flushActions.isEmpty(), "Expected flush actions to be empty when writing single threaded");
                if (isSubsystem) {
                    this.nextEntryIsSubsystem();
                }
                if (this.deflater == null) {
                    this.deflater = new Deflater(this.deflateLevel);
                } else {
                    this.deflater.setLevel(this.deflateLevel);
                    this.deflater.reset();
                }
                Mat5WriteUtil.writeArrayDeflated(name, isGlobal, array, this.sink, this.deflater);
                return this;
            }
            final Deflater deflater = new Deflater(this.deflateLevel);
            final BufferAllocator bufferAllocator = this.bufferAllocator;
            this.flushActions.add(this.executorService.submit(new Callable<FlushAction>(){

                @Override
                public FlushAction call() throws Exception {
                    int maxExpectedSize = Mat5WriteUtil.computeArraySize(name, array) + 256;
                    final ByteBuffer buffer = bufferAllocator.allocate(maxExpectedSize);
                    Sink tmpSink = Sinks.wrap(buffer).order(Mat5Writer.this.sink.order());
                    Mat5WriteUtil.writeArrayDeflated(name, isGlobal, array, tmpSink, deflater);
                    tmpSink.close();
                    buffer.flip();
                    return new FlushAction(){

                        @Override
                        public void run() throws IOException {
                            try {
                                if (isSubsystem) {
                                    Mat5Writer.this.nextEntryIsSubsystem();
                                }
                                Mat5Writer.this.sink.writeByteBuffer(buffer);
                            }
                            finally {
                                bufferAllocator.release(buffer);
                            }
                        }
                    };
                }
            }));
        }
        return this;
    }

    private void nextEntryIsSubsystem() throws IOException {
        this.subsysLocation = this.sink.position();
    }

    public Mat5Writer flush() throws IOException {
        for (Future<FlushAction> action : this.flushActions) {
            try {
                action.get().run();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.headerStart >= 0L && this.subsysLocation > 0L) {
            Mat5File.updateSubsysOffset(this.headerStart, this.subsysLocation, this.sink);
            this.subsysLocation = 0L;
        }
        return this;
    }

    Mat5Writer(Sink sink) {
        this.sink = Preconditions.checkNotNull(sink, "Sink can't be empty");
    }

    private static interface FlushAction {
        public void run() throws IOException;
    }
}

