/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.format.MatStruct;
import us.hebi.matlab.mat.format.McosObject;
import us.hebi.matlab.mat.types.AbstractStructBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.ObjectStruct;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Struct;

class McosReference
extends AbstractStructBase
implements ObjectStruct,
Opaque,
Mat5Serializable {
    final String objectType;
    final String className;
    final Array content;
    final int[] objectIds;
    final int classId;
    final McosObject[] objects;

    static McosReference parseMcosReference(Array content) {
        if (!McosReference.isMcosReference(content)) {
            throw new IllegalArgumentException("Not a valid reference");
        }
        return McosReference.parseOpaque("MCOS", "N/A", content);
    }

    static boolean isMcosReference(Array content) {
        if (content.getType() != MatlabType.UInt32) {
            return false;
        }
        if (content.getNumRows() < 5 || content.getNumCols() != 1) {
            return false;
        }
        Matrix data = (Matrix)content;
        return data.getInt(0) == -587202560 && data.getInt(1) == 2;
    }

    static McosReference parseOpaque(String objectType, String className, Array content) {
        Matrix data;
        if ("FileWrapper__".equals(className)) {
            throw new IllegalArgumentException("Only for references. Not for FileWrapper__ class");
        }
        if (!"MCOS".equals(objectType)) {
            throw new IllegalArgumentException("Expected objectType to be MCOS, was " + objectType);
        }
        if (McosReference.isMcosReference(content)) {
            data = (Matrix)content;
        } else if (content.getType() == MatlabType.Structure) {
            Cell values = (Cell)((MatStruct)content).get("Values");
            if (values.getNumElements() != 1) {
                throw new IllegalArgumentException("Expected values to be a 1x1 cell array, was " + values);
            }
            data = (Matrix)values.get(0);
        } else {
            throw new IllegalArgumentException("Unexpected MCOS object reference data type: " + content);
        }
        int[] dims = new int[]{data.getInt(2), data.getInt(3)};
        int numElements = McosReference.getNumElements(dims);
        if (numElements != data.getNumRows() - 5) {
            throw new IllegalArgumentException("Different number of references than dimensions");
        }
        int[] objectIds = new int[numElements];
        for (int i = 0; i < objectIds.length; ++i) {
            objectIds[i] = data.getInt(i + 4);
        }
        int classId = data.getInt(data.getNumRows() - 1);
        return new McosReference(dims, objectType, className, content, objectIds, classId);
    }

    private McosReference(int[] dims, String objectType, String className, Array content, int[] objectIds, int classId) {
        super(dims);
        this.content = content;
        this.className = className;
        this.objectType = objectType;
        this.objectIds = objectIds;
        this.classId = classId;
        this.objects = new McosObject[objectIds.length];
        Arrays.fill(this.objects, McosObject.EMPTY);
    }

    protected void setReferences(List<McosObject> objects) {
        for (int i = 0; i < this.objectIds.length; ++i) {
            this.objects[i] = objects.get(this.objectIds[i]);
        }
    }

    @Override
    public List<String> getFieldNames() {
        return this.isEmpty() ? Collections.emptyList() : this.objects[0].getFieldNames();
    }

    @Override
    public <T extends Array> T get(String field, int index) {
        return (T)this.objects[index].get(field);
    }

    @Override
    public Struct set(String field, int index, Array value) {
        this.objects[index].set(field, value);
        return this;
    }

    @Override
    public Array[] remove(String field) {
        throw new IllegalStateException("Can't remove fields from Reference Objects.");
    }

    @Override
    public MatlabType getType() {
        return MatlabType.Object;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public String getPackageName() {
        return this.isEmpty() ? "" : this.objects[0].getPackageName();
    }

    @Override
    public String getClassName() {
        return this.isEmpty() ? this.className : this.objects[0].getClassName();
    }

    @Override
    public Array getContent() {
        return this.content;
    }

    @Override
    public int getMat5Size(String name) {
        return Mat5WriteUtil.computeOpaqueSize(name, this);
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeOpaque(name, isGlobal, this, sink);
    }

    @Override
    public void close() throws IOException {
        this.content.close();
    }

    @Override
    public String toString() {
        return super.toString() + " for '" + this.getClassName() + "'";
    }

    private boolean isEmpty() {
        return this.objects.length == 0 || this.objects[0] == McosObject.EMPTY;
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(this.objectType, this.className, this.content, Arrays.hashCode(this.objectIds), this.classId, Arrays.hashCode(this.objects));
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        McosReference other = (McosReference)otherGuaranteedSameClass;
        return other.objectType.equals(this.objectType) && other.className.equals(this.className) && other.classId == this.classId && other.content.equals(this.content) && Arrays.equals(other.objectIds, this.objectIds) && Arrays.equals(other.objects, this.objects);
    }
}

