/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.format.NumberStore;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Bytes;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;

class UniversalNumberStore
implements NumberStore {
    final Mat5Type type;
    private final int numElements;
    ByteBuffer buffer;
    private BufferAllocator bufferAllocator;

    UniversalNumberStore(Mat5Type type, ByteBuffer buffer, BufferAllocator bufferAllocator) {
        this.type = type;
        this.buffer = Preconditions.checkNotNull(buffer);
        this.bufferAllocator = Preconditions.checkNotNull(bufferAllocator);
        this.numElements = buffer.remaining() / type.bytes();
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    @Override
    public double getDouble(int index) {
        switch (this.type) {
            case Single: {
                return this.buffer.getFloat(this.getOffset(index));
            }
            case Double: {
                return this.buffer.getDouble(this.getOffset(index));
            }
        }
        return this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        switch (this.type) {
            case Int8: {
                return this.buffer.get(this.getOffset(index));
            }
            case Int16: {
                return this.buffer.getShort(this.getOffset(index));
            }
            case Int32: {
                return this.buffer.getInt(this.getOffset(index));
            }
            case Int64: {
                return this.buffer.getLong(this.getOffset(index));
            }
            case UInt8: {
                return Casts.uint8(this.buffer.get(this.getOffset(index)));
            }
            case UInt16: {
                return Casts.uint16(this.buffer.getShort(this.getOffset(index)));
            }
            case UInt32: {
                return Casts.uint32(this.buffer.getInt(this.getOffset(index)));
            }
            case UInt64: {
                return this.buffer.getLong(this.getOffset(index));
            }
            case Single: {
                return (long)this.buffer.getFloat(this.getOffset(index));
            }
            case Double: {
                return (long)this.buffer.getDouble(this.getOffset(index));
            }
        }
        throw new IllegalArgumentException("Not a numerical type " + (Object)((Object)this.type));
    }

    @Override
    public void setDouble(int index, double value) {
        switch (this.type) {
            case Single: {
                this.buffer.putFloat(this.getOffset(index), (float)value);
                break;
            }
            case Double: {
                this.buffer.putDouble(this.getOffset(index), value);
                break;
            }
            default: {
                this.checkInputRange(Casts.isInteger(value), value);
                this.setLong(index, (long)value);
            }
        }
    }

    @Override
    public void setLong(int index, long value) {
        switch (this.type) {
            case Int8: 
            case UInt8: {
                this.checkInputRange(Casts.fitsByte(value), value);
                this.buffer.put(this.getOffset(index), (byte)value);
                break;
            }
            case Int16: 
            case UInt16: {
                this.checkInputRange(Casts.fitsShort(value), value);
                this.buffer.putShort(this.getOffset(index), (short)value);
                break;
            }
            case Int32: 
            case UInt32: {
                this.checkInputRange(Casts.fitsInt(value), value);
                this.buffer.putInt(this.getOffset(index), (int)value);
                break;
            }
            case Int64: 
            case UInt64: {
                this.buffer.putLong(this.getOffset(index), value);
                break;
            }
            case Single: {
                this.buffer.putFloat(this.getOffset(index), value);
                break;
            }
            case Double: {
                this.buffer.putDouble(this.getOffset(index), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a numerical type " + (Object)((Object)this.type));
            }
        }
    }

    private void checkInputRange(boolean state, double value) {
        if (!state) {
            String format = "Internal store type '%s' can not hold input value %f";
            throw new IllegalArgumentException(String.format(format, new Object[]{this.type, value}));
        }
    }

    private int getOffset(int index) {
        return index * this.type.bytes();
    }

    @Override
    public int getMat5Size() {
        return this.type.computeSerializedSize(this.numElements);
    }

    @Override
    public void writeMat5(Sink sink) throws IOException {
        if (this.buffer.order() != sink.order()) {
            Bytes.reverseByteOrder(this.buffer, this.type.bytes());
        }
        this.type.writeByteBufferWithTag(this.buffer, sink);
        this.buffer.rewind();
    }

    ByteBuffer getByteBuffer() {
        this.buffer.rewind();
        return this.buffer.slice();
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            System.err.println("already released!");
            return;
        }
        this.bufferAllocator.release(this.buffer);
        this.buffer = null;
        this.bufferAllocator = null;
    }

    static int hashCodeForType(NumberStore store, boolean logical, MatlabType type) {
        if (store == null) {
            return 0;
        }
        int hash = 1;
        if (logical) {
            for (int i = 0; i < store.getNumElements(); ++i) {
                hash = 31 * hash + (Casts.logical(store.getDouble(i)) ? 1 : 0);
            }
        } else if (type == MatlabType.Single || type == MatlabType.Double) {
            for (int i = 0; i < store.getNumElements(); ++i) {
                hash = 31 * hash + Compat.hashDouble(store.getDouble(i));
            }
        } else {
            for (int i = 0; i < store.getNumElements(); ++i) {
                hash = 31 * hash + Compat.hashLong(store.getLong(i));
            }
        }
        return hash;
    }

    static boolean equalForType(NumberStore a, NumberStore b, boolean logical, MatlabType type) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (a instanceof UniversalNumberStore && b instanceof UniversalNumberStore) {
            UniversalNumberStore aCast = (UniversalNumberStore)a;
            UniversalNumberStore bCast = (UniversalNumberStore)b;
            if (aCast.type == bCast.type) {
                return aCast.buffer.equals(bCast.buffer);
            }
        }
        if (logical) {
            for (int i = 0; i < a.getNumElements(); ++i) {
                if (Casts.logical(a.getDouble(i)) == Casts.logical(b.getDouble(i))) continue;
                return false;
            }
        } else if (type == MatlabType.Single || type == MatlabType.Double) {
            for (int i = 0; i < a.getNumElements(); ++i) {
                if (a.getDouble(i) == b.getDouble(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < a.getNumElements(); ++i) {
                if (a.getLong(i) == b.getLong(i)) continue;
                return false;
            }
        }
        return true;
    }
}

