/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class Unsafe9R {
    private static final boolean useJava9;

    public static void invokeCleaner(ByteBuffer directBuffer) {
        if (!directBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer is non-direct");
        }
        if (useJava9) {
            Java9.invokeCleaner(directBuffer);
        } else {
            Java6.invokeCleaner(directBuffer);
        }
    }

    static {
        String version = System.getProperty("java.specification.version", "6");
        String majorVersion = version.equals("0.9") ? "6" : (version.startsWith("1.") ? version.substring(2) : version);
        useJava9 = Integer.parseInt(majorVersion) >= 9;
    }

    private static class Java6 {
        static final Method GET_CLEANER;
        static final Method INVOKE_CLEANER;

        private Java6() {
        }

        static void invokeCleaner(ByteBuffer buffer) {
            try {
                Object cleaner = GET_CLEANER.invoke((Object)buffer, new Object[0]);
                if (cleaner != null) {
                    INVOKE_CLEANER.invoke(cleaner, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Java 6 Cleaner failed to free DirectBuffer", e);
            }
        }

        static {
            try {
                GET_CLEANER = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
                INVOKE_CLEANER = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Java 6 Cleaner not available", e);
            }
        }
    }

    private static class Java9 {
        static final Unsafe UNSAFE;
        static final Method INVOKE_CLEANER;

        private Java9() {
        }

        static void invokeCleaner(ByteBuffer buffer) {
            try {
                INVOKE_CLEANER.invoke((Object)UNSAFE, buffer);
            }
            catch (Exception e) {
                throw new IllegalStateException("Java 9 Cleaner failed to free DirectBuffer", e);
            }
        }

        static {
            try {
                PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                };
                UNSAFE = AccessController.doPrivileged(action);
                INVOKE_CLEANER = UNSAFE.getClass().getMethod("invokeCleaner", ByteBuffer.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Java 9 Cleaner not available", ex);
            }
        }
    }
}

