/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UnwantedExpressionInCommentCheckBase
extends CommentCheckBase {
    private Pattern unwantedRegex;

    @Override
    public void initialize() throws CheckException {
        super.initialize();
        this.unwantedRegex = this.getUnwantedRegex();
    }

    @Override
    protected void processComment(IToken token, int startLine, int endLine) throws CheckException {
        Matcher commentMatcher = this.unwantedRegex.matcher(token.getText());
        if (commentMatcher.find()) {
            this.buildFinding(this.getFindingText(token, commentMatcher.toMatchResult()), this.buildLocation().betweenLines(startLine, endLine)).createAndStore();
        }
    }

    protected abstract Pattern getUnwantedRegex();

    protected abstract String getFindingText(IToken var1, MatchResult var2);
}

