/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.js_export.ExportAsType;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass
public class MacroDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern NO_CPP_IDENTIFIER_CHAR_PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final Pattern DEFINE_PATTERN = Pattern.compile("#\\s*define\\s+", 2);
    public static final String DEFINE_DIRECTIVE_BEGIN = "#define ";
    private static final Logger LOGGER = LogManager.getLogger();
    @JsonProperty(value="macroName")
    public final String macroName;
    @JsonProperty(value="replacementList")
    public final @ExportAsType(value="Array<{offset: number, lineNumber: number, text: string, originId: string}>") List<IToken> replacementList;
    @JsonProperty(value="isFunctionMacro")
    public final boolean isFunctionMacro;
    @JsonProperty(value="parameterNames")
    public final UnmodifiableList<String> parameterNames;
    @JsonProperty(value="hasVariadicParameter")
    public final boolean hasVariadicParameter;
    @JsonProperty(value="macroDeclarationLocation")
    public final TextRegionLocation macroDeclarationLocation;
    @JsonProperty(value="isImmutable")
    public final boolean isImmutable;

    private MacroDefinition(String macroName, String replacementList, boolean isFunctionMacro, List<String> parameterNames, boolean hasVariadicParameter, TextRegionLocation macroDeclarationLocation, ELanguage language, boolean isImmutable) {
        this.macroName = Objects.requireNonNull(macroName);
        this.isImmutable = isImmutable;
        this.replacementList = MacroDefinition.scanAndFixStringificationTokens(replacementList, parameterNames, language);
        this.isFunctionMacro = isFunctionMacro;
        this.parameterNames = CollectionUtils.asUnmodifiable(parameterNames);
        this.hasVariadicParameter = hasVariadicParameter;
        this.macroDeclarationLocation = macroDeclarationLocation;
    }

    private static List<IToken> scanAndFixStringificationTokens(String replacementList, List<String> parameterNames, ELanguage language) {
        if (replacementList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IToken> replacementTokens = new ArrayList<IToken>();
        replacementList = MacroDefinition.removeMultilineCommentsAfterStringificationHash(replacementList);
        for (IToken token : ScannerUtils.getTokens(replacementList, language, "##macro##")) {
            if (MacroDefinition.isStringificationToken(token, parameterNames)) {
                replacementTokens.addAll(MacroDefinition.fixStringificationScanning(token, parameterNames, language));
                continue;
            }
            replacementTokens.add(token);
        }
        return replacementTokens;
    }

    private static String removeMultilineCommentsAfterStringificationHash(String replacementList) {
        Object result = replacementList;
        for (int i = 0; i < ((String)result).length(); ++i) {
            if (((String)result).charAt(i) != '#' || ((String)result).length() <= i + 4 || ((String)result).startsWith("##", i)) continue;
            String remainderText = ((String)result).substring(MacroDefinition.skipMultilineCommentsAndWhitespace((String)result, i + 1));
            result = remainderText.startsWith("#") ? ((String)result).substring(0, i + 1) + " " + remainderText : ((String)result).substring(0, i + 1) + remainderText;
        }
        return result;
    }

    public static MacroDefinition parseMacroDefinition(String macroDefinition, TextRegionLocation location, ELanguage language, boolean isImmutable) {
        try {
            boolean isFunctionMacro;
            macroDefinition = macroDefinition.replace("\\\n", " ").replace("\t", " ").trim();
            List<IToken> definitionTokens = CPreprocessingUtils.scanMacroContent(macroDefinition, language);
            List definitionTokensWithoutComments = CollectionUtils.filter(definitionTokens, token -> !TokenUtils.isCommentToken(token));
            if (definitionTokensWithoutComments.isEmpty()) {
                LOGGER.warn("Empty macro definition: " + macroDefinition + " at " + location.toLocationString() + ". Ignoring this define.");
                return new MacroDefinition("", "", false, Collections.emptyList(), false, location, language, isImmutable);
            }
            IToken macroNameToken = (IToken)definitionTokensWithoutComments.get(0);
            if (definitionTokensWithoutComments.size() == 1) {
                return new MacroDefinition(macroNameToken.getText(), "", false, Collections.emptyList(), false, location, language, isImmutable);
            }
            boolean bl = isFunctionMacro = ((IToken)definitionTokensWithoutComments.get(1)).getType() == ETokenType.LPAREN && ((IToken)definitionTokensWithoutComments.get(1)).getOffset() == macroNameToken.getEndOffset() + 1;
            if (isFunctionMacro) {
                return MacroDefinition.parseFunctionMacroDefinition(macroDefinition, definitionTokensWithoutComments, location, language, isImmutable);
            }
            return MacroDefinition.parseObjectMacro(definitionTokens, definitionTokensWithoutComments, location, language, isImmutable);
        }
        catch (AssertionError e) {
            throw new AssertionError("Error while parsing macro: " + macroDefinition, (Throwable)((Object)e));
        }
    }

    public static MacroDefinition parseMacroDefinition(String macroDefinition, TextRegionLocation location, ELanguage language) {
        return MacroDefinition.parseMacroDefinition(macroDefinition, location, language, false);
    }

    private static MacroDefinition parseObjectMacro(List<IToken> definitionTokens, List<IToken> definitionTokensWithoutComments, TextRegionLocation location, ELanguage language, boolean isImmutable) {
        int replacementListStartIndex = 1;
        List<IToken> replacementList = Collections.emptyList();
        if (replacementListStartIndex < definitionTokensWithoutComments.size()) {
            replacementList = definitionTokens.subList(definitionTokens.indexOf(definitionTokensWithoutComments.get(replacementListStartIndex)), definitionTokens.size());
        }
        IToken macroNameToken = definitionTokensWithoutComments.get(0);
        return new MacroDefinition(macroNameToken.getText(), MacroDefinition.rebuildTextFromTokens(replacementList), false, Collections.emptyList(), false, location, language, isImmutable);
    }

    private static MacroDefinition parseFunctionMacroDefinition(String definitionText, List<IToken> definitionTokensWithoutComments, TextRegionLocation location, ELanguage language, boolean isImmutable) {
        int parameterListEndIndex = TokenStreamUtils.findMatchingClosingToken(definitionTokensWithoutComments, 2, ETokenType.LPAREN, ETokenType.RPAREN);
        CCSMAssert.isTrue((parameterListEndIndex > 0 ? 1 : 0) != 0, (String)"Did not find closing parenthesis in function macro definition.");
        String replacementList = "";
        replacementList = definitionText.substring(definitionTokensWithoutComments.get(parameterListEndIndex).getOffset() + 1);
        Pair<List<String>, Boolean> parameterInfo = MacroDefinition.parseParameterList(definitionTokensWithoutComments.subList(2, parameterListEndIndex));
        List parameterNames = (List)parameterInfo.getFirst();
        boolean hasVariadicParameter = (Boolean)parameterInfo.getSecond();
        IToken macroNameToken = definitionTokensWithoutComments.get(0);
        return new MacroDefinition(macroNameToken.getText(), replacementList, true, parameterNames, hasVariadicParameter, location, language, isImmutable);
    }

    private static Pair<List<String>, Boolean> parseParameterList(List<IToken> parameterList) {
        boolean hasVariadicParameter = false;
        List parameterNames = CollectionUtils.map(TokenStreamUtils.splitWithNesting(parameterList, ETokenType.COMMA, ETokenType.LPAREN, ETokenType.RPAREN), TokenStreamTextUtils::concatTokenTexts);
        parameterNames.removeIf(String::isEmpty);
        if (!parameterNames.isEmpty() && ((String)CollectionUtils.getLast((List)parameterNames)).endsWith("...")) {
            hasVariadicParameter = true;
            String variadicParameterName = (String)CollectionUtils.getLast((List)parameterNames);
            if (variadicParameterName.equals("...")) {
                parameterNames.set(parameterNames.size() - 1, "__VA_ARGS__");
            } else {
                parameterNames.set(parameterNames.size() - 1, variadicParameterName.substring(0, variadicParameterName.length() - 3));
            }
        }
        return new Pair((Object)parameterNames, (Object)hasVariadicParameter);
    }

    public static boolean isStringificationToken(IToken token, List<String> parameterNames) {
        String tokenText = token.getText();
        if (tokenText.startsWith("#") && !tokenText.startsWith("##") && tokenText.length() > 1) {
            tokenText = tokenText.substring(1).trim();
            for (String parameterName : parameterNames) {
                if (!tokenText.startsWith(parameterName)) continue;
                if (tokenText.length() == parameterName.length()) {
                    return true;
                }
                char nextChar = tokenText.charAt(parameterName.length());
                if (Character.isLetter(nextChar) || Character.isDigit(nextChar) || nextChar == '_') continue;
                return true;
            }
        }
        return false;
    }

    private static int skipMultilineCommentsAndWhitespace(String tokenText, int startIndex) {
        int currentIndex = startIndex;
        currentIndex = MacroDefinition.findNextNonWhitespaceIndex(tokenText, currentIndex);
        while (tokenText.startsWith("/*", currentIndex)) {
            int indexOfCommentClosing = tokenText.indexOf("*/", currentIndex + 2);
            if (indexOfCommentClosing == -1) {
                return currentIndex;
            }
            currentIndex = indexOfCommentClosing + 2;
            currentIndex = MacroDefinition.findNextNonWhitespaceIndex(tokenText, currentIndex);
        }
        currentIndex = MacroDefinition.findNextNonWhitespaceIndex(tokenText, currentIndex);
        return currentIndex;
    }

    private static int findNextNonWhitespaceIndex(String tokenText, int start) {
        while (tokenText.length() > start && Character.isWhitespace(tokenText.charAt(start))) {
            ++start;
        }
        return start;
    }

    private static List<? extends IToken> fixStringificationScanning(IToken token, List<String> parameterNames, ELanguage language) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        ArrayDeque<IToken> tokensToFix = new ArrayDeque<IToken>(Collections.singletonList(token));
        while (!tokensToFix.isEmpty()) {
            int indexOfNonWhitespace;
            IToken currentToken = (IToken)tokensToFix.poll();
            if (!MacroDefinition.isStringificationToken(currentToken, parameterNames)) {
                result.add(currentToken);
                continue;
            }
            String text = currentToken.getText();
            for (indexOfNonWhitespace = 1; indexOfNonWhitespace < text.length() && text.charAt(indexOfNonWhitespace) == ' '; ++indexOfNonWhitespace) {
            }
            int indexOfNonIdentifierChar = StringUtils.indexOfMatch((String)text.substring(indexOfNonWhitespace), (Pattern)NO_CPP_IDENTIFIER_CHAR_PATTERN) + indexOfNonWhitespace;
            if (indexOfNonIdentifierChar < indexOfNonWhitespace) {
                result.add(currentToken);
                continue;
            }
            result.add(CPreprocessingUtils.scanMacroContent(text.substring(0, indexOfNonIdentifierChar), language).get(0));
            CPreprocessingUtils.scanMacroContent(text.substring(indexOfNonIdentifierChar), language).forEach(tokensToFix::add);
        }
        return result;
    }

    public List<String> getParametersThatRequireExpansion() {
        return this.replacementList.stream().map(IToken::getText).filter(arg_0 -> this.parameterNames.contains(arg_0)).distinct().collect(Collectors.toList());
    }

    public String toString() {
        if (this.isFunctionMacro) {
            Object parameterList = "";
            for (int i = 0; i < this.parameterNames.size(); ++i) {
                boolean isLastAndVariadicParameter;
                if (i != 0) {
                    parameterList = (String)parameterList + ", ";
                }
                String parameter = (String)this.parameterNames.get(i);
                boolean bl = isLastAndVariadicParameter = this.hasVariadicParameter && i == this.parameterNames.size() - 1;
                parameterList = isLastAndVariadicParameter && parameter.equals("__VA_ARGS__") ? (String)parameterList + "..." : (isLastAndVariadicParameter ? (String)parameterList + parameter + "..." : (String)parameterList + parameter);
            }
            return DEFINE_DIRECTIVE_BEGIN + this.macroName + "(" + (String)parameterList + ") " + MacroDefinition.rebuildTextFromTokens(this.replacementList);
        }
        return DEFINE_DIRECTIVE_BEGIN + this.macroName + " " + MacroDefinition.rebuildTextFromTokens(this.replacementList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroDefinition that = (MacroDefinition)o;
        return this.isFunctionMacro == that.isFunctionMacro && this.hasVariadicParameter == that.hasVariadicParameter && this.macroName.equals(that.macroName) && this.replacementList.equals(that.replacementList) && this.parameterNames.equals(that.parameterNames) && Objects.equals(this.macroDeclarationLocation, that.macroDeclarationLocation);
    }

    public int hashCode() {
        return Objects.hash(this.macroName, this.replacementList, this.isFunctionMacro, this.parameterNames, this.hasVariadicParameter, this.macroDeclarationLocation);
    }

    public static String rebuildTextFromTokens(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        int startOffset = tokens.get(0).getOffset();
        for (IToken token : tokens) {
            if (startOffset + text.length() < token.getOffset()) {
                text.append(" ".repeat(token.getOffset() - (text.length() + startOffset)));
            }
            text.append(token.getText());
        }
        return text.toString();
    }

    public static boolean isMacroDefinition(IToken token) {
        return token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && DEFINE_PATTERN.matcher(token.getText()).find();
    }

    public static MacroDefinition fromToken(IToken token) {
        CCSMAssert.isTrue((boolean)MacroDefinition.isMacroDefinition(token), (String)"The token is not a macro definition.");
        String tokenWithoutDirective = token.getText().trim().replaceFirst(DEFINE_PATTERN.pattern(), "").trim();
        return MacroDefinition.parseMacroDefinition(tokenWithoutDirective, null, token.getLanguage());
    }

    public String formatAsDCompilerParameter() {
        if (this.isFunctionMacro) {
            String parameterList = "(" + StringUtils.concat(this.parameterNames, (String)",") + ")";
            return "-D\"" + this.macroName + parameterList + "=" + MacroDefinition.rebuildTextFromTokens(this.replacementList) + "\"";
        }
        if (this.replacementList.isEmpty()) {
            return "-D" + this.macroName + "=";
        }
        if (this.replacementList.size() == 1) {
            return "-D" + this.macroName + "=" + this.replacementList.get(0).getText();
        }
        return "-D\"" + this.macroName + "=" + MacroDefinition.rebuildTextFromTokens(this.replacementList) + "\"";
    }
}

