/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.MacroInvocationPreprocessor;
import eu.cqse.check.framework.scanner.IToken;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class MacroExpansionStepsLogger {
    private static final int MAX_ASSUMED_MESSAGE_LENGTH = 30;
    public static final MacroExpansionStepsLogger NO_OP = new MacroExpansionStepsLogger(){

        @Override
        public void incrementNestingDepth() {
        }

        @Override
        public void decrementNestingDepth() {
        }

        @Override
        public void logStatusMessage(List<IToken> macroContent, String logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        }

        @Override
        public void logStatusMessage(List<IToken> macroContent, Supplier<String> logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        }

        @Override
        public void logStatusMessage(List<IToken> currentTokens1, List<IToken> currentTokens2, String logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        }

        @Override
        public void logStatusMessage(String messageTag, Supplier<String> messageContent) {
        }
    };
    private final Writer outputWriter;
    private int nestingDepth = 0;

    public MacroExpansionStepsLogger(PrintStream outputPrintStream) {
        this.outputWriter = new OutputStreamWriter((OutputStream)outputPrintStream, StandardCharsets.UTF_8);
    }

    public MacroExpansionStepsLogger(Writer outputPrintWriter) {
        this.outputWriter = outputPrintWriter;
    }

    private MacroExpansionStepsLogger() {
        this.outputWriter = null;
    }

    public void incrementNestingDepth() {
        ++this.nestingDepth;
    }

    public void decrementNestingDepth() {
        --this.nestingDepth;
    }

    public void logStatusMessage(List<IToken> macroContent, String logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        try {
            logMessage = (String)logMessage + CPreprocessingUtils.getFillerSpaces((String)logMessage, 30);
            String currentContent = MacroExpansionStepsLogger.concatTokenTextsWithBluePaintMarkers(macroContent, tokenDisablingContext);
            String completeMessage = "  ".repeat(this.nestingDepth + 1) + (String)logMessage + currentContent;
            this.outputWriter.write(completeMessage + "\n");
            this.outputWriter.flush();
        }
        catch (IOException e) {
            LogManager.getLogger().error("IOException while writing preprocessor expansion steps:", (Throwable)e);
        }
    }

    public void logStatusMessage(List<IToken> macroContent, Supplier<String> logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        this.logStatusMessage(macroContent, logMessage.get(), tokenDisablingContext);
    }

    public void logStatusMessage(List<IToken> currentTokens1, List<IToken> currentTokens2, String logMessage, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        this.logStatusMessage(CPreprocessingUtils.concat(currentTokens1, currentTokens2), logMessage, tokenDisablingContext);
    }

    private static String concatTokenTextsWithBluePaintMarkers(List<IToken> tokens, MacroInvocationPreprocessor.TokenDisablingContext tokenDisablingContext) {
        Function<IToken, String> computeTokenRepresentation = token -> {
            if (tokenDisablingContext.isPaintedBlue((IToken)token)) {
                return token.getText() + "\u00b0";
            }
            return token.getText();
        };
        return StringUtils.concat((Iterable)CollectionUtils.map(tokens, computeTokenRepresentation), (String)" ");
    }

    public void logStatusMessage(String messageTag, Supplier<String> messageContent) {
        try {
            String fillerSpaces = CPreprocessingUtils.getFillerSpaces(messageTag, 30);
            String completeMessage = "  ".repeat(this.nestingDepth + 1) + messageTag + fillerSpaces + messageContent.get();
            this.outputWriter.write(completeMessage + "\n");
            this.outputWriter.flush();
        }
        catch (IOException e) {
            LogManager.getLogger().error("IOException while writing preprocessor expansion steps:", (Throwable)e);
        }
    }
}

