/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.SequenceRecognizer;
import java.util.EnumMap;
import java.util.List;
import java.util.Stack;

class SkipToRecognizer<STATE extends Enum<STATE>>
extends SequenceRecognizer<STATE> {
    private final EnumMap<ETokenType, ETokenType> nestingMap = new EnumMap(ETokenType.class);
    private RecognizerBase<STATE> subRecognizer;

    public SkipToRecognizer(List<ITokenMatcher> matchTerms, boolean reportStartOfEndMatch) {
        super(matchTerms, reportStartOfEndMatch);
    }

    public void addNestingTokens(ETokenType open, ETokenType close) {
        this.nestingMap.put(open, close);
    }

    public void setSubRecognizer(RecognizerBase<STATE> subRecognizer) {
        this.subRecognizer = subRecognizer;
    }

    @Override
    public int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        Stack<ETokenType> expectedTokens = new Stack<ETokenType>();
        for (int offset = startOffset; offset < tokens.size(); ++offset) {
            int match;
            int match2;
            if (this.subRecognizer != null && (match2 = this.subRecognizer.matches(parserState, tokens, offset)) != -1) {
                offset = match2 - 1;
                continue;
            }
            ETokenType type = tokens.get(offset).getType();
            if (!expectedTokens.isEmpty() && expectedTokens.peek() == type) {
                expectedTokens.pop();
                continue;
            }
            ETokenType closing = this.nestingMap.get(type);
            if (closing != null) {
                expectedTokens.push(closing);
                continue;
            }
            if (!expectedTokens.isEmpty() || (match = super.matchesLocally(parserState, tokens, offset)) == -1) continue;
            return match;
        }
        return -1;
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        Object subRecognizerPart = "";
        if (this.subRecognizer != null) {
            subRecognizerPart = "[" + String.valueOf(this.subRecognizer) + "]";
        }
        return "skipTo" + this.matchTermString() + (String)subRecognizerPart;
    }
}

