/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.abap_cds;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.abap_cds.SkipToSemicolonOrEofRecognizer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class AbapCdsShallowParser
extends ShallowParserBase<EAbapCdsParserStates> {
    private static final List<ETokenType> OPENING_TOKENS = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK);
    private static final List<ETokenType> CLOSING_TOKENS = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK);

    public AbapCdsShallowParser() {
        super(EAbapCdsParserStates.class, EAbapCdsParserStates.TOP_LEVEL);
        this.createTopLevelRules();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, OPENING_TOKENS, CLOSING_TOKENS).createNode(EShallowEntityType.STATEMENT, "simple statement").endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ETokenClass.KEYWORD}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, OPENING_TOKENS, CLOSING_TOKENS).createNode(EShallowEntityType.STATEMENT, "simple statement").endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createTopLevelRules() {
        this.createAnnotationRules();
        this.createViewDefinitionRules();
        this.createEntityExtensionRules();
        this.createTableFunctionRules();
        this.createHierarchyDefinitionRules();
        this.createCustomEntityDefinitionRules();
        this.createAbstractEntityDefinitionRules();
        this.createMetadataExtensionDefinitionRules();
        this.createBehaviorDefinitionRules();
        this.createAuthorizationContextRules();
        this.createRoleDefinitionRules();
        this.createAccessPolicyDefinitionRules();
        this.createServiceDefinitionRules();
        this.createTypeDefinitionRules();
    }

    private void createAnnotationRules() {
        ITokenMatcher identifierLikeTokens = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD});
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT_OPERATOR}).markStart().repeated(new ITokenMatcher[]{identifierLikeTokens, ETokenType.DOT}).sequence(new ITokenMatcher[]{identifierLikeTokens, ETokenType.COLON, ETokenType.ETokenClass.LITERAL}).createNode(EShallowEntityType.META, "Annotation with value", INameResolver.ofRange(0, -3)).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT_OPERATOR}).markStart().repeated(new ITokenMatcher[]{identifierLikeTokens, ETokenType.DOT}).sequence(identifierLikeTokens).sequence(new ITokenMatcher[]{ETokenType.COLON, identifierLikeTokens}).createNode(EShallowEntityType.META, "Annotation with value", INameResolver.ofRange(0, -3)).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT_OPERATOR}).markStart().repeated(new ITokenMatcher[]{identifierLikeTokens, ETokenType.DOT}).sequence(identifierLikeTokens).createNode(EShallowEntityType.META, "Annotation without value", INameResolver.ofRange(0, -1)).endNode();
    }

    private void createViewDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRANSIENT, ETokenType.ROOT})).sequence(new ITokenMatcher[]{ETokenType.VIEW, ETokenType.ENTITY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "View Entity Definition", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).optional(new ITokenMatcher[]{ETokenType.ROOT}).sequence(new ITokenMatcher[]{ETokenType.VIEW, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "View Definition", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createEntityExtensionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXTEND}).optional(new ITokenMatcher[]{ETokenType.VIEW}).optional(new ITokenMatcher[]{ETokenType.CUSTOM}).optional(new ITokenMatcher[]{ETokenType.ABSTRACT}).optional(new ITokenMatcher[]{ETokenType.ENTITY}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Entity Extension", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createTableFunctionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.TABLE, ETokenType.FUNCTION, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Table Function Definition", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createHierarchyDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.HIERARCHY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Hierarchy Definition", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).endNode();
    }

    private void createCustomEntityDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).optional(new ITokenMatcher[]{ETokenType.ROOT}).sequence(new ITokenMatcher[]{ETokenType.CUSTOM, ETokenType.ENTITY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Custom Entity Definition", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createAbstractEntityDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).optional(new ITokenMatcher[]{ETokenType.ROOT}).sequence(new ITokenMatcher[]{ETokenType.ABSTRACT, ETokenType.ENTITY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Abstract Entity Definition", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createMetadataExtensionDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ANNOTATE, ETokenType.ENTITY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Metadata extension", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ANNOTATE, ETokenType.VIEW, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Metadata extension", INameResolver.previousTokenText()).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createBehaviorDefinitionRules() {
        for (ETokenType eTokenType : EnumSet.of(ETokenType.IMPLEMENTATION, new ETokenType[]{ETokenType.MANAGED, ETokenType.UNMANAGED, ETokenType.ABSTRACT, ETokenType.PROJECTION, ETokenType.INTERFACE})) {
            this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{eTokenType}).createNode(EShallowEntityType.META, "Behavior Definition Implementation Type", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        }
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.STRICT}).createNode(EShallowEntityType.META, "Behavior Definition Strict Mode", INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.WITH, ETokenType.DRAFT}).createNode(EShallowEntityType.META, "Behavior Definition with draft", "with draft").sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.USE}).createNode(EShallowEntityType.META, "Behavior Definition use declaration", "use").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.WITH, ETokenType.PRIVILEGED, ETokenType.MODE}).createNode(EShallowEntityType.META, "Behavior Definition with privileged mode", "with privileged mode").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.FOREIGN, ETokenType.ENTITY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "Behavior Definition foreign entity", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXTENSIBLE, ETokenType.LBRACE}).createNode(EShallowEntityType.META, "Behavior Definition extensible clause").skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXTENSIBLE}).createNode(EShallowEntityType.META, "Behavior Definition extensible clause").endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.BEHAVIOR, ETokenType.FOR, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Behavior Definition", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAuthorizationContextRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DEFINE, ETokenType.AUTHORIZATION, ETokenType.CONTEXT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Authorization Context Definition", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DEFINE, ETokenType.OWN, ETokenType.AUTHORIZATION, ETokenType.CONTEXT, ETokenType.BY, ETokenType.PRIVILEGED, ETokenType.MODE, ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "Own Authorization Context Definition").endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DEFINE, ETokenType.OWN, ETokenType.AUTHORIZATION, ETokenType.CONTEXT}).createNode(EShallowEntityType.METHOD, "Own Authorization Context Definition").skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).endNode();
    }

    private void createRoleDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.ROLE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Role Definition", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAccessPolicyDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.ACCESSPOLICY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Access Policy", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.ASPECT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "ASPECT_DEFINITION", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).subRecognizer(new SkipToSemicolonOrEofRecognizer(OPENING_TOKENS, CLOSING_TOKENS)).endNode();
    }

    private void createServiceDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.SERVICE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Service Definition", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createTypeDefinitionRules() {
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.METHOD, "Type Definition", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, OPENING_TOKENS, CLOSING_TOKENS).endNode();
        this.inState(new EAbapCdsParserStates[]{EAbapCdsParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.DEFINE}).sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "Type Definition", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK)).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, OPENING_TOKENS, CLOSING_TOKENS).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    public static enum EAbapCdsParserStates {
        TOP_LEVEL;

    }
}

