/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.base;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppSkipTemplateSpecificationRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cs.CSharpUsingDeclarationRecognizer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.Nullable;

public abstract class CStyleShallowParserBase
extends ShallowParserBase<EGenericParserStates> {
    private EGenericParserStates[] availableStatementScopes = new EGenericParserStates[]{EGenericParserStates.IN_METHOD};

    protected CStyleShallowParserBase() {
        super(EGenericParserStates.class, EGenericParserStates.TOP_LEVEL);
        this.createRules();
    }

    protected CStyleShallowParserBase(EnumSet<EGenericParserStates> availableScopes) {
        super(EGenericParserStates.class, EGenericParserStates.TOP_LEVEL);
        this.availableStatementScopes = (EGenericParserStates[])ArrayUtils.addAll((Object[])this.availableStatementScopes, (Object[])availableScopes.toArray(new EGenericParserStates[1]));
        this.createRules();
    }

    private void createRules() {
        this.createMetaRules();
        this.createTypeRules();
        this.createClassElementsRules();
        this.createStatementRules();
        this.createSubExpressionRules();
    }

    protected void createMetaRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.RBRACE}).createNode(EShallowEntityType.META, "dangling closing brace");
    }

    protected void createTypeRules() {
        this.inAnyState().repeated(this.getTypeModifier()).markStart().sequence(this.getTypeKeywordsMatcher(), this.getIdentifierMatcher()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.LBRACE})).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    protected void createTypedefRules() {
        RecognizerBase typeInTypedefAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.TYPEDEF}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONST, ETokenType.VOLATILE}));
        typeInTypedefAlternative.sequenceBefore(new ITokenMatcher[]{this.getTypeKeywordsMatcher(), ETokenType.IDENTIFIER, ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText()).parseOnce(EGenericParserStates.TOP_LEVEL).markStart().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNodeWithName(INameResolver.firstMatchedTokenText());
        typeInTypedefAlternative.sequenceBefore(new ITokenMatcher[]{this.getTypeKeywordsMatcher(), ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText()).parseOnce(EGenericParserStates.TOP_LEVEL).markStart().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNodeWithName(INameResolver.firstMatchedTokenText());
        RecognizerBase simpleTypedefAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.TYPEDEF}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText()).skipBeforeWithNesting(List.of(ETokenType.IDENTIFIER, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN, ETokenType.LBRACK})), Collections.singletonList(ETokenType.LT), Collections.singletonList(ETokenType.GT), null);
        simpleTypedefAlternative.markStart().sequenceBefore(new ITokenMatcher[]{ETokenType.IDENTIFIER, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.LBRACK})}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACK, ETokenType.RBRACK).endNodeWithName(INameResolver.firstMatchedTokenText());
        simpleTypedefAlternative.markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.RPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNodeWithName(INameResolver.firstMatchedTokenText());
    }

    protected ITokenMatcher getTypeModifier() {
        return ITokenMatcher.never();
    }

    public abstract ITokenMatcher getTypeKeywordsMatcher();

    protected abstract void createClassElementsRules();

    protected void createStatementRules() {
        this.createEmptyStatementRule();
        this.createLabelRule();
        this.createElseIfRule();
        this.createBasicBlockRules();
        this.createCaseRule();
        this.createDoWhileRule();
        this.createGenericBlockRule();
        this.createSimpleStatementRule();
    }

    private void createEmptyStatementRule() {
        this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createLabelRule() {
        this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{this.getIdentifierMatcher(), ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createElseIfRule() {
        RecognizerBase<EGenericParserStates> elseIfAlternative = this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).optional(new ITokenMatcher[]{ETokenType.CONSTEXPR}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndices(0, 1));
        this.endBlockRule(elseIfAlternative, (ITokenMatcher)ETokenType.ELSE, true, false);
    }

    protected void createBasicBlockRules() {
        INameResolver subtype = INameResolver.firstMatchedTokenText();
        this.createBasicBlockRule(this.getBlockRuleStart(), this.getSimpleBlockKeywordsWithParentheses(), null, true, false, subtype);
        this.createBasicBlockRule(this.getBlockRuleStart(), this.getSimpleBlockKeywordsWithoutParentheses(), null, false, false, subtype);
        this.createBasicBlockRule(this.getBlockRuleStart(), (ITokenMatcher)ETokenType.IF, (ITokenMatcher)ETokenType.ELSE, true, false, subtype);
        this.createBasicBlockRule(this.getBlockRuleStart(), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}), true, true, subtype);
    }

    protected RecognizerBase<EGenericParserStates> getBlockRuleStart() {
        return this.inState(this.availableStatementScopes);
    }

    protected void createBasicBlockRule(RecognizerBase<EGenericParserStates> blockRuleStart, ITokenMatcher startTokens, @Nullable ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, boolean alwaysBraces, INameResolver blockNodeSubtype) {
        RecognizerBase<EGenericParserStates> blockRule = blockRuleStart.sequence(startTokens).notPreCondition(new CSharpUsingDeclarationRecognizer());
        if (alwaysBraces) {
            blockRule = canBeFollowedByParentheses ? blockRule.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.LPAREN})) : blockRule.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        }
        blockRule = blockRule.createNode(EShallowEntityType.STATEMENT, blockNodeSubtype);
        this.endBasicBlockRule(blockRule, continuationTokens, canBeFollowedByParentheses, alwaysBraces);
    }

    public void endBasicBlockRule(RecognizerBase<EGenericParserStates> blockRule, @Nullable ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, boolean alwaysBraces) {
        if (canBeFollowedByParentheses) {
            blockRule = blockRule.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        }
        if (alwaysBraces) {
            blockRule = blockRule.skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        }
        this.endWithPossibleContinuation(blockRule.optional(this.getOptionalTokensBeforeBlockBraces()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(blockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
    }

    protected ITokenMatcher getOptionalTokensBeforeBlockBraces() {
        return ITokenMatcher.never();
    }

    protected void createCaseRule() {
        this.inState(this.availableStatementScopes).markStart().sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting(this.getCaseStatementEndTokens(), ETokenType.QUESTION, ETokenType.COLON, this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LT, ETokenType.QUESTION}))).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).endNode();
        this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, this.getCaseStatementEndTokens()}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }

    protected void createDoWhileRule() {
        RecognizerBase<EGenericParserStates> doWhileAlternative = this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        doWhileAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        doWhileAlternative.parseOnce(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createGenericBlockRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    public void contributeSimpleStatementRules(ITokenMatcher localVariableIdentifiers, ITokenMatcher statementStartTokens) {
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        this.completeSimpleStatement(this.typePatternInState(this.availableStatementScopes).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).markStart().sequenceBefore(localVariableIdentifiers, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.EQ, ETokenType.SEMICOLON, ETokenType.LBRACK})), "local variable");
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.UNION}).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).markStart().sequenceBefore(new ITokenMatcher[]{localVariableIdentifiers, ETokenType.SEMICOLON}), "local variable");
        this.completeSimpleStatement(this.typePatternInState(this.availableStatementScopes).repeated(new ITokenMatcher[]{ETokenType.LPAREN}).sequence(new ITokenMatcher[]{ETokenType.MULT}).markStart().sequenceBefore(new ITokenMatcher[]{localVariableIdentifiers, ETokenType.RPAREN}), "local variable");
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.USING}).optional(new ITokenMatcher[]{ETokenType.VAR}).skipAfter(new ITokenMatcher[]{ETokenType.IDENTIFIER}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).sequence(new ITokenMatcher[]{ETokenType.USING}).sequence(new ITokenMatcher[]{ETokenType.VAR}).markStart().sequenceBefore(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
        this.createRuleForSimpleStatementHavingStartTokens(statementStartTokens);
        this.completeSimpleStatement(this.typePatternInState(this.availableStatementScopes));
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).sequence(new ITokenMatcher[]{ETokenType.ETokenClass.LITERAL}));
    }

    protected void createRuleForSimpleStatementHavingStartTokens(ITokenMatcher statementStartTokens) {
        this.completeSimpleStatement(this.inState(this.availableStatementScopes).sequence(statementStartTokens));
    }

    protected void createSimpleStatementRule() {
        this.contributeSimpleStatementRules(this.getIdentifierMatcher(), this.getStatementStartTokens());
    }

    protected void createSubExpressionRules() {
    }

    public RecognizerBase<EGenericParserStates> getSubExpressionRecognizer() {
        return null;
    }

    public ITokenMatcher getIdentifierMatcher() {
        return ETokenType.IDENTIFIER;
    }

    protected abstract ITokenMatcher getSimpleBlockKeywordsWithParentheses();

    protected abstract ITokenMatcher getSimpleBlockKeywordsWithoutParentheses();

    public ITokenMatcher getCaseStatementEndTokens() {
        return ETokenType.COLON;
    }

    public abstract ITokenMatcher getStatementStartTokens();

    public abstract RecognizerBase<EGenericParserStates> typePattern(RecognizerBase<EGenericParserStates> var1);

    protected RecognizerBase<EGenericParserStates> typePatternInState(EGenericParserStates ... states) {
        return this.typePattern(this.inState(states));
    }

    protected void endBlockRule(RecognizerBase<EGenericParserStates> blockRule, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, boolean alwaysBraces) {
        if (canBeFollowedByParentheses) {
            blockRule = blockRule.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        }
        if (alwaysBraces) {
            blockRule = blockRule.skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        }
        this.endWithPossibleContinuation(blockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(blockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
    }

    public void completeSimpleStatement(RecognizerBase<EGenericParserStates> baseRecognizer) {
        this.completeSimpleStatement(baseRecognizer, "simple statement");
    }

    public void completeSimpleStatement(RecognizerBase<EGenericParserStates> baseRecognizer, String subtype) {
        RecognizerBase<EGenericParserStates> alternative = baseRecognizer.createNode(EShallowEntityType.STATEMENT, subtype, INameResolver.firstMatchedTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE}), ETokenType.LBRACE, ETokenType.RBRACE, ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        alternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        alternative.sequence(new ITokenMatcher[0]);
    }

    protected void createLambdaWithArrowRules(ETokenType arrowType) {
        CStyleShallowParserBase.completeLambda(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(this.getIdentifierMatcher()), arrowType);
        CStyleShallowParserBase.completeLambda(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN), arrowType);
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{arrowType}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofString("lambda expression"), INameResolver.noName(), 1).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.COMMA}), ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LBRACE, ETokenType.RBRACE, this.getSubExpressionRecognizer()).endNode();
    }

    private static void completeLambda(RecognizerBase<EGenericParserStates> ruleStart, ETokenType arrowType) {
        RecognizerBase<EGenericParserStates> lambdaAlternative = ruleStart.createNode(EShallowEntityType.METHOD, "lambda");
        lambdaAlternative.sequence(new ITokenMatcher[]{arrowType, ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        lambdaAlternative.sequenceBefore(new ITokenMatcher[]{arrowType}).parseOnce(EGenericParserStates.IN_EXPRESSION).endNode();
    }

    public static int skipOptionalParameters(List<IToken> tokens, int currentOffset) {
        if (!TokenStreamUtils.hasTokenTypeSequence(tokens, currentOffset, ETokenType.LPAREN)) {
            return currentOffset;
        }
        int closingParenthesis = TokenStreamUtils.findMatchingClosingToken(tokens, currentOffset + 1, ETokenType.LPAREN, ETokenType.RPAREN);
        if (closingParenthesis == -1) {
            return -1;
        }
        return closingParenthesis + 1;
    }

    public RecognizerBase<EGenericParserStates> createScopeRecognizer() {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.SCOPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.SCOPE}));
    }
}

