/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.List;

public class CppLambdaRecognizer
extends RecognizerBase<EGenericParserStates> {
    private final ITokenMatcher typeOrIdentifier;

    public CppLambdaRecognizer(ITokenMatcher typeOrIdentifier) {
        this.typeOrIdentifier = typeOrIdentifier;
    }

    @Override
    protected int matchesLocally(ParserState<EGenericParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset > 0 && tokens.get(startOffset - 1).getType() == ETokenType.RBRACK) {
            return -1;
        }
        if (startOffset > 0 && this.isPrecededByType(tokens, startOffset)) {
            return -1;
        }
        int currentOffset = CppLambdaRecognizer.skipCaptureList(tokens, startOffset);
        if (currentOffset == -1) {
            return -1;
        }
        if ((currentOffset = CStyleShallowParserBase.skipOptionalParameters(tokens, currentOffset)) == -1) {
            return -1;
        }
        return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
    }

    private boolean isPrecededByType(List<IToken> tokens, int currentOffset) {
        IToken precedingToken = tokens.get(currentOffset - 1);
        return this.typeOrIdentifier.matches(precedingToken);
    }

    private static int skipCaptureList(List<IToken> tokens, int currentOffset) {
        if (!TokenStreamUtils.hasTokenTypeSequence(tokens, currentOffset, ETokenType.LBRACK)) {
            return -1;
        }
        if (currentOffset + 1 >= tokens.size() || tokens.get(currentOffset + 1).getType() == ETokenType.LBRACK) {
            return -1;
        }
        int closingBracket = TokenStreamUtils.findMatchingClosingToken(tokens, currentOffset + 1, ETokenType.LBRACK, ETokenType.RBRACK);
        if (closingBracket == -1) {
            return -1;
        }
        return closingBracket + 1;
    }
}

