/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.oscript;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.oscript.EOScriptParserState;

public class OScriptShallowParser
extends ShallowParserBase<EOScriptParserState> {
    private static final ITokenMatcher VARIABLE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOLEAN, ETokenType.INTEGER, ETokenType.REAL, ETokenType.STRING, ETokenType.OBJECT, ETokenType.ASSOC, ETokenType.LIST, ETokenType.DATE, ETokenType.DYNAMIC, ETokenType.IDENTIFIER});
    private static final ITokenMatcher STATEMENT_END_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON});
    private static final ITokenMatcher OSCRIPT_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ADDFEATURE, ETokenType.AND, ETokenType.ASSOC, ETokenType.BOOLEAN, ETokenType.BREAK, ETokenType.BREAKIF, ETokenType.BY, ETokenType.CASE, ETokenType.CONTINUE, ETokenType.CONTINUEIF, ETokenType.DATE, ETokenType.DEFAULT, ETokenType.DEFINE, ETokenType.DO, ETokenType.DOWNTO, ETokenType.DYNAMIC, ETokenType.ELSE, ETokenType.ELSEIF, ETokenType.END, ETokenType.ENDIF, ETokenType.ENDSCRIPT, ETokenType.FINAL, ETokenType.FOR, ETokenType.FUNCTION, ETokenType.GE, ETokenType.GOTO, ETokenType.GT, ETokenType.IF, ETokenType.IFDEF, ETokenType.IFNDEF, ETokenType.IN, ETokenType.INHERITS, ETokenType.INTEGER, ETokenType.INTERFACE, ETokenType.LE, ETokenType.LIST, ETokenType.LT, ETokenType.NAME, ETokenType.NE, ETokenType.NODEBUG, ETokenType.NONE, ETokenType.NOT, ETokenType.OBJECT, ETokenType.OR, ETokenType.OVERRIDE, ETokenType.PACKAGE, ETokenType.PARENT, ETokenType.PRIVATE, ETokenType.PUBLIC, ETokenType.REAL, ETokenType.REPEAT, ETokenType.RETURN, ETokenType.SCRIPT, ETokenType.SET, ETokenType.STRING, ETokenType.SUPER, ETokenType.SWITCH, ETokenType.THEN, ETokenType.THIS, ETokenType.TO, ETokenType.UNDEFINED, ETokenType.UNTIL, ETokenType.USING, ETokenType.WHILE});
    private static final ITokenMatcher MODIFIER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OVERRIDE, ETokenType.PUBLIC, ETokenType.PRIVATE});

    public OScriptShallowParser() {
        super(EOScriptParserState.class, EOScriptParserState.TOP_LEVEL);
        this.createTopLevelRules();
        this.createVariableRules();
        this.createFunctionRules();
        this.createScriptRules();
        this.createRulesForStatements();
    }

    private void createVariableRules() {
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL}).subRecognizer(this.getTypeRecognizer()).subRecognizer(this.getVariableRecognizer()).createNode(EShallowEntityType.ATTRIBUTE, "global variable", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.IN_OBJECT, EOScriptParserState.IN_SCRIPT}).optional(MODIFIER).optionalSubRecognizer(this.getTypeRecognizer()).subRecognizer(this.getVariableRecognizer()).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.IN_FUNCTION}).subRecognizer(this.getTypeRecognizer()).subRecognizer(this.getVariableRecognizer()).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.IN_FUNCTION}).subRecognizer(this.getVariableNameRecognizer()).subRecognizer(this.getDeclarationRecognizer()).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText()).endNode();
        this.inAnyState().subRecognizer(this.getVariableNameRecognizer()).subRecognizer(this.getAssignmentRecognizer()).createNode(EShallowEntityType.STATEMENT, "assignment", INameResolver.firstMatchedTokenText()).endNode();
    }

    private RecognizerBase<EOScriptParserState> getVariableRecognizer() {
        return this.createRecognizer(start -> start.subRecognizer(this.getVariableNameRecognizer()).subRecognizer(this.getStatementEndRecognizer()));
    }

    private RecognizerBase<EOScriptParserState> getVariableNameRecognizer() {
        return this.createRecognizer(start -> {
            RecognizerBase<EOScriptParserState> prefix = start.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOLLAR, ETokenType.DOT})).markStart().optionalSubRecognizer(this.getMethodCallRecognizer(false)).optional(new ITokenMatcher[]{ETokenType.DOT}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT});
            prefix.repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
            prefix.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        });
    }

    private RecognizerBase<EOScriptParserState> getDeclarationRecognizer() {
        return this.createRecognizer(start -> {
            start.sequence(new ITokenMatcher[]{ETokenType.COMMA});
            start.sequence(STATEMENT_END_TOKENS);
        });
    }

    private RecognizerBase<EOScriptParserState> getAssignmentRecognizer() {
        return this.createRecognizer(start -> {
            RecognizerBase<EOScriptParserState> prefix = start.sequence(new ITokenMatcher[]{ETokenType.EQUAL});
            prefix.subRecognizer(this.getMethodCallRecognizer(false)).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER});
            prefix.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE);
            prefix.sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK);
            prefix.skipAfter(STATEMENT_END_TOKENS);
        });
    }

    private RecognizerBase<EOScriptParserState> getStatementEndRecognizer() {
        return this.createRecognizer(start -> {
            start.subRecognizer(this.getDeclarationRecognizer());
            start.subRecognizer(this.getAssignmentRecognizer());
        });
    }

    private RecognizerBase<EOScriptParserState> getTypeRecognizer() {
        return this.createRecognizer(start -> start.optional(MODIFIER).sequence(VARIABLE_TYPES).sequenceBefore(new ITokenMatcher[]{ETokenType.IDENTIFIER}));
    }

    private RecognizerBase<EOScriptParserState> getMethodCallRecognizer(boolean markStart) {
        return this.createRecognizer(start -> {
            if (markStart) {
                start.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOLLAR, ETokenType.DOT})).markStart().subRecognizer(this.getSimpleMethodCallRecognizer(), 1, Integer.MAX_VALUE);
            } else {
                start.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOLLAR, ETokenType.DOT})).subRecognizer(this.getSimpleMethodCallRecognizer(), 1, Integer.MAX_VALUE);
            }
        });
    }

    private RecognizerBase<EOScriptParserState> getSimpleMethodCallRecognizer() {
        return this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.DOT}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    private void createTopLevelRules() {
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).skipAfter(STATEMENT_END_TOKENS).createNode(EShallowEntityType.MODULE, "package", INameResolver.ofRange(1, -2)).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PUBLIC, ETokenType.OBJECT, ETokenType.IDENTIFIER}).markStart().createNode(EShallowEntityType.TYPE, "object", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.INHERITS, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOUBLE_COLON, ETokenType.IDENTIFIER}).parseUntil(EOScriptParserState.IN_OBJECT).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NAME, ETokenType.PARENT, ETokenType.ADDFEATURE})).skipAfter(STATEMENT_END_TOKENS).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PREPROCESSOR_DIRECTIVE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createScriptRules() {
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_OBJECT}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OVERRIDE, ETokenType.PUBLIC, ETokenType.PRIVATE})).sequence(new ITokenMatcher[]{ETokenType.SCRIPT, OSCRIPT_IDENTIFIERS}).createNode(EShallowEntityType.TYPE, "script", INameResolver.previousTokenText()).parseUntil(EOScriptParserState.IN_SCRIPT).sequence(new ITokenMatcher[]{ETokenType.ENDSCRIPT}).endNode();
    }

    private void createFunctionRules() {
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_OBJECT, EOScriptParserState.IN_SCRIPT}).optional(MODIFIER).sequence(new ITokenMatcher[]{ETokenType.FUNCTION, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOLEAN, ETokenType.INTEGER, ETokenType.REAL, ETokenType.STRING, ETokenType.OBJECT, ETokenType.ASSOC, ETokenType.LIST, ETokenType.DATE, ETokenType.DYNAMIC, ETokenType.VOID}), OSCRIPT_IDENTIFIERS, ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "function", INameResolver.ofIndex(2)).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createRulesForStatements() {
        this.createRulesForConditionStatements();
        this.createRulesForLoopStatements();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.STATEMENT, "label").optional(STATEMENT_END_TOKENS).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.GOTO, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText()).optional(STATEMENT_END_TOKENS).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.BREAKIF, ETokenType.CONTINUEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(STATEMENT_END_TOKENS).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.STATEMENT, "label", INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_END_TOKENS).endNode();
        this.inAnyState().subRecognizer(this.getMethodCallRecognizer(true)).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createRulesForConditionStatements() {
        this.createIfRules(ETokenType.IF);
        this.createIfRules(ETokenType.ELSE);
        this.createIfRules(ETokenType.ELSEIF);
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfterWithNesting(STATEMENT_END_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting(STATEMENT_END_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.ofIndices(0, 1)).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, STATEMENT_END_TOKENS}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createIfRules(ETokenType conditionToken) {
        RecognizerBase<EOScriptParserState> ifRecognizer = this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{conditionToken}).skipAfterWithNesting(STATEMENT_END_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EOScriptParserState.IN_FUNCTION);
        if (conditionToken == ETokenType.ELSE) {
            ifRecognizer.sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
            return;
        }
        ifRecognizer.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.ELSEIF})).endNodeWithContinuation();
        ifRecognizer.sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createRulesForLoopStatements() {
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        RecognizerBase forRecognizer = this.inState(new EOScriptParserState[]{EOScriptParserState.TOP_LEVEL, EOScriptParserState.IN_FUNCTION, EOScriptParserState.IN_SCRIPT}).sequence(new ITokenMatcher[]{ETokenType.FOR}).markStart();
        forRecognizer.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndex(-2)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(STATEMENT_END_TOKENS).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        forRecognizer.skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndex(-3)).parseUntil(EOScriptParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }
}

