/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.cs;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.typetracker.clike.CLikeTypeInfoExtractorBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CsTypeInfoExtractor
extends CLikeTypeInfoExtractorBase {
    public CsTypeInfoExtractor() {
        super(LanguageFeatureParser.CS);
    }

    @Override
    public List<TypedVariable> extractFromStatement(ShallowEntity statementEntity) {
        switch (statementEntity.getSubtype()) {
            case "local variable": {
                return this.extractFromVariableTokens(statementEntity, (List<IToken>)statementEntity.ownStartTokens());
            }
            case "for": {
                return this.extractFromForLikeTokens(statementEntity, ETokenType.SEMICOLON);
            }
            case "catch": {
                return this.extractFromCatchTokens(statementEntity);
            }
            case "foreach": {
                return this.extractFromForLikeTokens(statementEntity, ETokenType.IN);
            }
            case "using": {
                return this.extractFromForLikeTokens(statementEntity, ETokenType.RPAREN);
            }
        }
        return super.extractFromStatement(statementEntity);
    }

    @Override
    protected List<TypedVariable> extractFromVariableTokens(ShallowEntity entity, List<IToken> variableTokens) {
        if (entity.getSubtype().equals("using")) {
            return this.extractFromUsingVariableTokens(entity, variableTokens);
        }
        return super.extractFromVariableTokens(entity, variableTokens);
    }

    private List<TypedVariable> extractFromUsingVariableTokens(ShallowEntity entity, List<IToken> variableTokens) {
        if (TokenStreamUtils.contains(variableTokens, ETokenType.EQ)) {
            return super.extractFromVariableTokens(entity, variableTokens);
        }
        return CollectionUtils.emptyList();
    }
}

