/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.IMethodCallMatcher;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodCallMatchers
implements IMethodCallMatcher {
    private final List<JavaMethodCallMatcher> matchers = new ArrayList<JavaMethodCallMatcher>();

    private MethodCallMatchers() {
    }

    public static MethodCallMatchers combine(JavaMethodCallMatcher ... matchers) {
        MethodCallMatchers collector = new MethodCallMatchers();
        collector.matchers.addAll(Arrays.asList(matchers));
        return collector;
    }

    @Override
    public List<JavaMethodCallMatcher.MethodCall> find(ICheckContext checkContext, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        return this.find(checkContext.getRootEntity(ECodeViewOption.FILTERED), checkContext.getTypeResolution(ECodeViewOption.FILTERED), typeResolver);
    }

    @Override
    public List<JavaMethodCallMatcher.MethodCall> find(ShallowEntity root, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        ArrayList<JavaMethodCallMatcher.MethodCall> result = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        for (JavaMethodCallMatcher matcher : this.matchers) {
            result.addAll(matcher.find(root, typeResolution, typeResolver));
        }
        return result;
    }
}

