/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.variable;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.variable.IVariableUseFilter;
import eu.cqse.check.framework.util.variable.VariableReadFilter;
import eu.cqse.check.framework.util.variable.VariableWriteFilter;
import java.util.ArrayList;
import java.util.List;

public class CLikeVariableUseExtractor {
    private final ITokenMatcher accessOperators;
    private final ITokenMatcher noVariableSuccessorTypes;

    public CLikeVariableUseExtractor(ITokenMatcher accessOperators, ITokenMatcher noVariableSuccessorTypes) {
        this.accessOperators = accessOperators;
        this.noVariableSuccessorTypes = noVariableSuccessorTypes;
    }

    public List<Integer> extractVariableUses(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.extractFilteredVariableUses(tokens, variableName, isField, isShadowed, IVariableUseFilter.ACCEPT_ALL);
    }

    public List<Integer> extractVariableReads(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.extractFilteredVariableUses(tokens, variableName, isField, isShadowed, VariableReadFilter.INSTANCE);
    }

    public List<Integer> extractVariableWrites(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.extractFilteredVariableUses(tokens, variableName, isField, isShadowed, VariableWriteFilter.INSTANCE);
    }

    private List<Integer> extractFilteredVariableUses(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed, IVariableUseFilter filter) {
        List<Integer> useIndices = TokenStreamTextUtils.findAll(tokens, variableName);
        return this.filterUses(tokens, useIndices, isField, isShadowed, filter);
    }

    private List<Integer> filterUses(List<IToken> tokens, List<Integer> useIndices, boolean isField, boolean isShadowed, IVariableUseFilter filter) {
        ArrayList<Integer> filteredUses = new ArrayList<Integer>();
        for (int index : useIndices) {
            if (!this.isVariableUse(tokens, index, isField, isShadowed) || !filter.isFiltered(tokens, index, isField)) continue;
            filteredUses.add(index);
        }
        return filteredUses;
    }

    private boolean isVariableUse(List<IToken> tokens, int index, boolean isField, boolean isShadowed) {
        if (index < tokens.size() - 1 && this.noVariableSuccessorTypes.matches(tokens.get(index + 1))) {
            return false;
        }
        if (isField) {
            return this.isFieldUse(tokens, index, isShadowed);
        }
        return this.isLocalUse(tokens, index, isShadowed);
    }

    private boolean isFieldUse(List<IToken> tokens, int index, boolean isShadowed) {
        return !isShadowed || index > 1 && this.accessOperators.matches(tokens.get(index - 1));
    }

    private boolean isLocalUse(List<IToken> tokens, int index, boolean isShadowed) {
        return !isShadowed && (index <= 1 || !this.accessOperators.matches(tokens.get(index - 1)));
    }
}

